/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client.gfx.particle;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import pro.komaru.tridot.client.gfx.particle.ScreenParticle;

@OnlyIn(value=Dist.CLIENT)
public abstract class QuadScreenParticle
extends ScreenParticle {
    protected float quadSize = 0.1f * (random.m_188501_() * 0.5f + 0.5f) * 2.0f;

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY) {
        super(pLevel, pX, pY);
    }

    protected QuadScreenParticle(ClientLevel pLevel, double pX, double pY, double pXSpeed, double pYSpeed) {
        super(pLevel, pX, pY, pXSpeed, pYSpeed);
    }

    @Override
    public void render(BufferBuilder bufferBuilder) {
        float partialTicks = Minecraft.m_91087_().getPartialTick();
        float size = this.getQuadSize(partialTicks) * 10.0f;
        float u0 = this.getU0();
        float u1 = this.getU1();
        float v0 = this.getV0();
        float v1 = this.getV1();
        Vector3f[] vectors = this.getVector3fs(partialTicks, size);
        float quadZ = this.getQuadZPosition();
        bufferBuilder.m_5483_((double)vectors[0].x(), (double)vectors[0].y(), (double)quadZ).m_7421_(u1, v1).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
        bufferBuilder.m_5483_((double)vectors[1].x(), (double)vectors[1].y(), (double)quadZ).m_7421_(u1, v0).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
        bufferBuilder.m_5483_((double)vectors[2].x(), (double)vectors[2].y(), (double)quadZ).m_7421_(u0, v0).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
        bufferBuilder.m_5483_((double)vectors[3].x(), (double)vectors[3].y(), (double)quadZ).m_7421_(u0, v1).m_85950_(this.rCol, this.gCol, this.bCol, this.alpha).m_5752_();
    }

    private Vector3f @NotNull [] getVector3fs(float partialTicks, float size) {
        float roll = Mth.m_14179_((float)partialTicks, (float)this.oRoll, (float)this.roll);
        Vector3f[] vectors = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Quaternionf rotation = new Quaternionf((Quaternionfc)Axis.f_252393_.m_252977_(roll));
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = vectors[i];
            vector3f.rotate((Quaternionfc)rotation);
            vector3f.mul(size);
            vector3f.add((float)this.x, (float)this.y, 0.0f);
        }
        return vectors;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize;
    }

    public float getQuadZPosition() {
        return 390.0f;
    }

    protected abstract float getU0();

    protected abstract float getU1();

    protected abstract float getV0();

    protected abstract float getV1();
}

