/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.client;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import pro.komaru.tridot.api.render.bossbars.ClientBossbar;
import pro.komaru.tridot.api.render.bossbars.ClientBossbarRegistry;
import pro.komaru.tridot.common.config.ClientConfig;
import pro.komaru.tridot.common.networking.packets.UpdateBossbarPacket;
import pro.komaru.tridot.mixin.client.BossHealthOverlayAccessor;
import pro.komaru.tridot.util.Col;

public class BossBarsOverlay
implements IGuiOverlay {
    public static final BossBarsOverlay INSTANCE = new BossBarsOverlay();
    public static final Map<UUID, ClientBossbar> events = Maps.newLinkedHashMap();

    public void update(UpdateBossbarPacket pPacket) {
        pPacket.dispatch(new UpdateBossbarPacket.Handler(){

            @Override
            public void add(UUID uuid, ResourceLocation type, ResourceLocation texture, Component pName, float health, float maxHealth, Col color, SoundEvent event, boolean pPlayBossMusic, boolean pDarkenScreen, boolean pCreateWorldFog, boolean isRainbow) {
                ClientBossbar bossbar = ClientBossbarRegistry.create(type, uuid);
                bossbar.setHealth(health, maxHealth);
                this.updateName(bossbar, pName);
                this.updateStyle(bossbar, color);
                this.updateProperties(bossbar, type, texture, event, pDarkenScreen, pPlayBossMusic, pCreateWorldFog, isRainbow);
                events.put(uuid, bossbar);
            }

            @Override
            public void remove(UUID uuid) {
                events.remove(uuid);
            }

            @Override
            public void updateProgress(UUID uuid, float health, float maxHealth) {
                ClientBossbar bossbar = events.get(uuid);
                bossbar.setHealth(health, maxHealth);
                float percent = maxHealth > 0.0f ? health / maxHealth : 0.0f;
                bossbar.setPercentage(percent);
            }

            @Override
            public void updateName(UUID uuid, Component component) {
                ClientBossbar bossbar = events.get(uuid);
                this.updateName(bossbar, component);
            }

            @Override
            public void updateStyle(UUID uuid, Col color) {
                ClientBossbar bossbar = events.get(uuid);
                this.updateStyle(bossbar, color);
            }

            @Override
            public void updateProperties(UUID uuid, ResourceLocation type, ResourceLocation texture, SoundEvent event, boolean darkenSky, boolean shouldPlayBossMusic, boolean createFog, boolean isRainbow, boolean aboutToDie) {
                ClientBossbar bossbar = events.get(uuid);
                bossbar.setAboutToDie(aboutToDie);
                this.updateProperties(bossbar, type, texture, event, darkenSky, shouldPlayBossMusic, createFog, isRainbow);
            }

            public void updateName(ClientBossbar bossbar, Component component) {
                bossbar.setName(component);
            }

            public void updateStyle(ClientBossbar bossbar, Col color) {
                bossbar.setColor(color);
            }

            public void updateProperties(ClientBossbar bossbar, ResourceLocation type, ResourceLocation texture, SoundEvent event, boolean darkenSky, boolean shouldPlayBossMusic, boolean createFog, boolean isRainbow) {
                bossbar.setTexture(texture);
                bossbar.setType(type);
                bossbar.setDarkenScreen(darkenSky);
                bossbar.setBossMusic(event);
                bossbar.setPlayBossMusic(shouldPlayBossMusic);
                bossbar.setRainbow(isRainbow);
                bossbar.setCreateWorldFog(createFog);
            }
        });
    }

    public static void reset() {
        events.clear();
    }

    public void render(ForgeGui gui, GuiGraphics pGuiGraphics, float partialTick, int screenWidth, int screenHeight) {
        Minecraft minecraft = gui.getMinecraft();
        if (minecraft.f_91066_.f_92062_ && events.isEmpty()) {
            return;
        }
        PoseStack pose = pGuiGraphics.m_280168_();
        pose.m_85836_();
        int y = 0;
        int baseOffset = BossBarsOverlay.calculateBossBarsOffset(minecraft);
        int renderedCount = 0;
        for (ClientBossbar bossbar : events.values()) {
            if (renderedCount >= (Integer)ClientConfig.BOSSBARS_LIMIT.get()) {
                return;
            }
            bossbar.render(this, pGuiGraphics, baseOffset + y, minecraft);
            y += bossbar.increment;
            ++renderedCount;
        }
        pose.m_85849_();
    }

    public static int calculateBossBarsOffset(Minecraft minecraft) {
        BossHealthOverlay bossOverlay = minecraft.f_91065_.m_93090_();
        Map<UUID, LerpingBossEvent> events = ((BossHealthOverlayAccessor)bossOverlay).getEvents();
        return events.size() * 20;
    }
}

