/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.render.text;

import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import pro.komaru.tridot.Tridot;
import pro.komaru.tridot.client.ClientTick;
import pro.komaru.tridot.client.gfx.text.DotStyle;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Log;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.math.Direction2;
import pro.komaru.tridot.util.math.Mathf;
import pro.komaru.tridot.util.phys.Vec2;
import pro.komaru.tridot.util.struct.Structs;
import pro.komaru.tridot.util.struct.func.Prov;

public class DotStyleEffects {
    static ArcRandom random = Tmp.rnd;
    public static Map<String, DotStyle.EffectEntry> EFFECTS = new LinkedHashMap<String, DotStyle.EffectEntry>();

    public static DotStyle.StyleEffect read(CompoundTag tag) {
        String id = tag.m_128461_("id");
        if (EFFECTS.containsKey(id)) {
            DotStyle.EffectEntry entry = EFFECTS.get(id);
            DotStyle.StyleEffect effect = entry.get();
            effect.read(tag);
            return effect;
        }
        Log.error("Unknown style effect: " + id, new Object[0]);
        return null;
    }

    public static void write(DotStyle.StyleEffect effect, CompoundTag tag) {
        tag.m_128359_("id", effect.id().toString());
        effect.write(tag);
    }

    public static DotStyle.StyleEffect getEmpty(ResourceLocation effect) {
        return EFFECTS.get(effect.toString()).get();
    }

    public static void add(Prov<DotStyle.StyleEffect> ... effectObjects) {
        for (Prov<DotStyle.StyleEffect> effectObject : effectObjects) {
            DotStyleEffects.add(effectObject);
        }
    }

    public static void add(Prov<DotStyle.StyleEffect> effectObject) {
        DotStyleEffects.add(effectObject.get().id(), effectObject);
    }

    @Deprecated
    public static void add(ResourceLocation effect, Prov<DotStyle.StyleEffect> effectObject) {
        EFFECTS.put(effect.toString(), new DotStyle.EffectEntry(effectObject, effect));
    }

    static {
        DotStyleEffects.add(AdvanceFX::new, ShakeFX::new, ScaleFX::new, WaveFX::new, RainbowFX::new, GlintFX::new, SpinFX::new, OutlineFX::new, PulseAlphaFX::new, PulseColorFX::new, AdvanceWaveFX::new);
    }

    public static class AdvanceWaveFX
    extends DotStyle.StyleEffect {
        public float speed = 1.0f;
        public float power = 1.0f;

        public static AdvanceWaveFX of(float speed, float power) {
            AdvanceWaveFX fx = new AdvanceWaveFX();
            fx.speed = speed;
            fx.power = power;
            return fx;
        }

        public static AdvanceWaveFX of(float speed) {
            return AdvanceWaveFX.of(speed, 1.0f);
        }

        public static AdvanceWaveFX of() {
            return AdvanceWaveFX.of(1.0f, 1.0f);
        }

        @Override
        public float advance(float advance) {
            return advance + (float)((Math.sin(ClientTick.getTotal() / 20.0f * this.speed) + 1.0) / 2.0 * (double)this.power);
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("advance_wave");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("speed", this.speed);
            tag.m_128350_("power", this.power);
        }

        @Override
        public void read(CompoundTag tag) {
            this.speed = tag.m_128457_("speed");
            this.power = tag.m_128457_("power");
        }
    }

    public static class PulseColorFX
    extends DotStyle.StyleEffect {
        public float intensity;
        float hue;

        public static PulseColorFX of(float intensity) {
            PulseColorFX fx = new PulseColorFX();
            fx.intensity = intensity;
            return fx;
        }

        public static PulseColorFX of() {
            return PulseColorFX.of(1.0f);
        }

        @Override
        public float alpha(float alpha) {
            this.hue = (float)(Math.sin(ClientTick.getTotal() * 0.05f * this.intensity) * 0.5 + 0.5);
            return alpha * this.hue;
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.hue = (float)(Math.sin((float)ClientTick.ticksInGame * 0.05f * this.intensity) * 0.5 + 0.5);
            if (this.hue > 1.0f || this.hue < 0.0f) {
                this.hue += (random.nextFloat() - 0.5f) * 0.1f;
                this.hue = Math.max(0.0f, Math.min(1.0f, this.hue));
            }
            style.color(Col.HSVtoRGB(this.hue * 360.0f, 100.0f, 100.0f));
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("pulse_color");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("intensity", this.intensity);
        }

        @Override
        public void read(CompoundTag tag) {
            this.intensity = tag.m_128457_("intensity");
        }
    }

    public static class PulseAlphaFX
    extends DotStyle.StyleEffect {
        public float intensity = 1.0f;
        float pulse;

        public static PulseAlphaFX of(float intensity) {
            PulseAlphaFX fx = new PulseAlphaFX();
            fx.intensity = intensity;
            return fx;
        }

        public static PulseAlphaFX of() {
            return PulseAlphaFX.of(1.0f);
        }

        @Override
        public float alpha(float alpha) {
            return alpha * Mathf.clamp(this.pulse);
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.pulse = (float)(1.0 - Math.abs(0.3 * Math.sin(ClientTick.getTotal() / 20.0f * this.intensity)));
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("pulse_alpha");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("intensity", this.intensity);
        }

        @Override
        public void read(CompoundTag tag) {
            this.intensity = tag.m_128457_("intensity");
        }
    }

    public static class OutlineFX
    extends DotStyle.StyleEffect {
        public Col textCol;
        public boolean square;

        public static OutlineFX of(Col textCol, boolean square) {
            OutlineFX fx = new OutlineFX();
            fx.textCol = textCol;
            fx.square = square;
            return fx;
        }

        public static OutlineFX of(Col textCol) {
            return OutlineFX.of(textCol, false);
        }

        @Override
        public void beforeGlyphEffects(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
            Font font = Minecraft.m_91087_().f_91062_;
            VertexConsumer vertexconsumer = self.f_92937_.m_6299_(bakedglyph.m_181387_(self.f_181362_));
            Col col = Structs.or(this.textCol, Col.black);
            for (Vec2 vec2 : this.square ? Direction2.d8 : Direction2.d4) {
                font.m_253238_(bakedglyph, style.m_131154_(), style.m_131161_(), 1.0f, self.f_92948_ + f7 + vec2.x, self.f_92949_ + f7 + vec2.y, self.f_92945_, vertexconsumer, f, f1, f2, f3, self.f_92947_);
            }
            font.m_253238_(bakedglyph, style.m_131154_(), style.m_131161_(), 1.0f, self.f_92948_ + f7, self.f_92949_ + f7, self.f_92945_, vertexconsumer, col.r, col.g, col.b, col.a * f3, self.f_92947_);
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("outline");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128405_("text_color", this.textCol.toARGB());
            tag.m_128379_("square", this.square);
        }

        @Override
        public void read(CompoundTag tag) {
            this.textCol = Col.fromARGB(tag.m_128451_("text_color"));
            this.square = tag.m_128471_("square");
        }
    }

    public static class SpinFX
    extends DotStyle.StyleEffect {
        public float speed = 1.0f;
        float x;
        float y;

        public static SpinFX of(float speed) {
            SpinFX fx = new SpinFX();
            fx.speed = speed;
            return fx;
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.x = self.f_92948_ + 2.5f;
            this.y = self.f_92949_ + 4.5f;
            self.f_92945_.translate(this.x, this.y, 0.0f);
            self.f_92945_.rotateZ(ClientTick.getTotal() / 20.0f * this.speed);
            self.f_92945_.translate(-this.x, -this.y, 0.0f);
        }

        @Override
        public void afterGlyph(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
            self.f_92945_.translate(this.x, this.y, 0.0f);
            self.f_92945_.rotateZ(-ClientTick.getTotal() / 20.0f * this.speed);
            self.f_92945_.translate(-this.x, -this.y, 0.0f);
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("spin");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("speed", this.speed);
        }

        @Override
        public void read(CompoundTag tag) {
            this.speed = tag.m_128457_("speed");
        }
    }

    public static class GlintFX
    extends DotStyle.StyleEffect {
        public float speed = 1.0f;
        public float scl = 1.0f;
        public Col glintColor;
        Col col;

        public static GlintFX of(float speed, float scl, Col glintColor) {
            GlintFX fx = new GlintFX();
            fx.speed = speed;
            fx.scl = scl;
            fx.glintColor = glintColor;
            return fx;
        }

        public static GlintFX of(float speed, float scl) {
            return GlintFX.of(speed, scl, Col.white);
        }

        public static GlintFX of(float speed) {
            return GlintFX.of(speed, 1.0f, Col.white);
        }

        public static GlintFX of() {
            return GlintFX.of(1.0f, 1.0f, Col.white);
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.col = style.color();
            float t = (ClientTick.getTotal() * this.speed - (float)index / this.scl) / 60.0f;
            t = Mathf.sin(t * Mathf.PI);
            style.color(this.col.copy().lerp(this.glintColor, t));
        }

        @Override
        public void afterGlyph(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
            style.color(this.col);
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("glint");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("speed", this.speed);
            tag.m_128350_("scl", this.scl);
        }

        @Override
        public void read(CompoundTag tag) {
            this.speed = tag.m_128457_("speed");
            this.scl = tag.m_128457_("scl");
        }
    }

    public static class RainbowFX
    extends DotStyle.StyleEffect {
        public float intensity;
        public boolean shiftSymbols;
        float off;
        Col col;

        public static RainbowFX of(float intensity, boolean shiftSymbols) {
            RainbowFX fx = new RainbowFX();
            fx.intensity = intensity;
            fx.shiftSymbols = shiftSymbols;
            return fx;
        }

        public static RainbowFX of(float intensity) {
            return RainbowFX.of(intensity, false);
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.off = this.shiftSymbols ? ((float)index * 36.0f + ClientTick.getTotal() * 3.25f * this.intensity) % 360.0f : ((float)index * 0.05f + ClientTick.getTotal() * 1.0f * this.intensity) % 360.0f;
            this.col = style.f_131101_ == null ? Col.white : Col.fromARGB(style.f_131101_.m_131265_());
            style.color(Col.HSVtoRGB(this.off, 90.0f, 100.0f));
        }

        @Override
        public void afterGlyph(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("rainbow");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("intensity", this.intensity);
            tag.m_128379_("shift_symbols", this.shiftSymbols);
        }

        @Override
        public void read(CompoundTag tag) {
            this.intensity = tag.m_128457_("intensity");
            this.shiftSymbols = tag.m_128471_("shift_symbols");
        }
    }

    public static class WaveFX
    extends DotStyle.StyleEffect {
        public float intensity;
        public float charIntensity;
        float off;

        public static WaveFX of(float intensity, float charIntensity) {
            WaveFX fx = new WaveFX();
            fx.intensity = intensity;
            fx.charIntensity = charIntensity;
            return fx;
        }

        public static WaveFX of(float intensity) {
            return WaveFX.of(intensity, 1.0f);
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.off = (float)Math.sin(Math.toDegrees((float)index * this.charIntensity * 0.02f + ClientTick.getTotal() * 0.005f * this.intensity));
            self.f_92949_ += this.off;
        }

        @Override
        public void afterGlyph(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
            self.f_92949_ -= this.off;
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("wave");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("intensity", this.intensity);
            tag.m_128350_("char_intensity", this.charIntensity);
        }

        @Override
        public void read(CompoundTag tag) {
            this.intensity = tag.m_128457_("intensity");
            this.charIntensity = tag.m_128457_("char_intensity");
        }
    }

    public static class ScaleFX
    extends DotStyle.StyleEffect {
        public float sclx = 1.0f;
        public float scly = 1.0f;
        float x;
        float y;

        public static ScaleFX of(float sclx, float scly) {
            ScaleFX fx = new ScaleFX();
            fx.sclx = sclx;
            fx.scly = scly;
            return fx;
        }

        public static ScaleFX of(float scl) {
            return ScaleFX.of(scl, scl);
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.x = self.f_92948_;
            this.y = self.f_92949_ + 8.0f;
            self.f_92945_.translate(this.x, this.y, 0.0f);
            self.f_92945_.scale(this.sclx, this.scly, 1.0f);
            self.f_92945_.translate(-this.x, -this.y, 0.0f);
        }

        @Override
        public void afterGlyph(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
            self.f_92945_.translate(this.x, this.y, 0.0f);
            self.f_92945_.scale(1.0f / this.sclx, 1.0f / this.scly, 1.0f);
            self.f_92945_.translate(-this.x, -this.y, 0.0f);
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("scale");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("sclx", this.sclx);
            tag.m_128350_("scly", this.scly);
        }

        @Override
        public void read(CompoundTag tag) {
            this.sclx = tag.m_128457_("sclx");
            this.scly = tag.m_128457_("scly");
        }
    }

    public static class ShakeFX
    extends DotStyle.StyleEffect {
        public float xi;
        public float yi;
        float offX;
        float offY;

        public static ShakeFX of(float xi, float yi) {
            ShakeFX fx = new ShakeFX();
            fx.xi = xi;
            fx.yi = yi;
            return fx;
        }

        public static ShakeFX of(float xi) {
            return ShakeFX.of(xi, xi);
        }

        @Override
        public void beforeGlyph(Font.StringRenderOutput self, DotStyle style, int index) {
            this.offX = (float)((double)this.xi * random.nextGaussian());
            this.offY = (float)((double)this.yi * random.nextGaussian());
            self.f_92948_ += this.offX;
            self.f_92949_ += this.offY;
        }

        @Override
        public void afterGlyph(Font.StringRenderOutput self, DotStyle style, int index, FontSet fontset, GlyphInfo glyphinfo, BakedGlyph bakedglyph, TextColor textcolor, float f, float f1, float f2, float f3, float f6, float f7) {
            self.f_92948_ -= this.offX;
            self.f_92949_ -= this.offY;
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("shake");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("xi", this.xi);
            tag.m_128350_("yi", this.yi);
        }

        @Override
        public void read(CompoundTag tag) {
            this.xi = tag.m_128457_("xi");
            this.yi = tag.m_128457_("yi");
        }
    }

    public static class AdvanceFX
    extends DotStyle.StyleEffect {
        public float advance;

        public static AdvanceFX of(float advance) {
            AdvanceFX fx = new AdvanceFX();
            fx.advance = advance;
            return fx;
        }

        @Override
        public float advance(float advance) {
            return advance + this.advance;
        }

        @Override
        public ResourceLocation id() {
            return Tridot.ofTridot("advance");
        }

        @Override
        public void write(CompoundTag tag) {
            tag.m_128350_("advance", this.advance);
        }

        @Override
        public void read(CompoundTag tag) {
            this.advance = tag.m_128457_("advance");
        }
    }
}

