/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import pro.komaru.tridot.util.struct.func.Cons;

public class GuiDraw {
    private PoseStack localPose;
    private GuiGraphics localG;

    public GuiDraw(GuiGraphics g) {
        this.localG = g;
        this.localPose = g.m_280168_();
    }

    public void push() {
        this.localPose.m_85836_();
    }

    public void pop() {
        this.localPose.m_85849_();
    }

    public void scissorsOn(int x, int y, int w, int h) {
        this.localG.m_280588_(x, y, x + w, y + h);
    }

    public void scissorsOff() {
        this.localG.m_280618_();
    }

    public void blit(String texture, int x, int y, int cutx, int cuty, int cutw, int cuth, int tw, int th) {
        ResourceLocation location = new ResourceLocation(texture);
        this.localG.m_280163_(location, x, y, (float)cutx, (float)cuty, cutw, cuth, tw, th);
    }

    public void blit(String texture, int x, int y, int tw, int ty) {
        this.blit(texture, x, y, 0, 0, tw, ty, tw, ty);
    }

    public void blit(String texture, int x, int y, int cutx, int cuty, int cutw, int cuth) {
        this.blit(texture, x, y, cutx, cuty, cutw, cuth, 256, 256);
    }

    public void color(float r, float g, float b, float a) {
        if (this.localG != null) {
            this.localG.m_280246_(r, g, b, a);
        } else {
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
        }
    }

    public void color(float r, float g, float b) {
        this.color(r, g, b, this.color(3));
    }

    public void color(float a) {
        this.color(this.color(0), this.color(1), this.color(2), a);
    }

    public void color() {
        this.color(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public float color(int idx) {
        return RenderSystem.getShaderColor()[idx];
    }

    public void move(float x, float y, float z) {
        this.pose(p -> p.m_252880_(x, y, z));
    }

    public void move(float x, float y) {
        this.move(x, y, 0.0f);
    }

    public void rotate(float angle) {
        this.localPose.m_252781_(Axis.f_252403_.m_252977_(angle));
    }

    public void rotate(float px, float py, float angle) {
        this.move(px, py);
        this.rotate(angle);
        this.move(-px, -py);
    }

    public void scale(float x, float y, float px, float py) {
        this.move(px, py);
        this.scale(x, y);
        this.move(-px, -py);
    }

    public void scale(float x, float y, float z) {
        this.pose(p -> p.m_85841_(x, y, z));
    }

    public void scale(float x, float y) {
        this.scale(x, y, 1.0f);
    }

    public void scale(float xy) {
        this.scale(xy, xy);
    }

    public void layer(float z) {
        this.move(0.0f, 0.0f, z);
    }

    public void pose(Cons<PoseStack> p) {
        if (this.localPose != null) {
            p.get(this.localPose);
        }
    }
}

