/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.level;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public abstract class BaseSpawner {
    public int spawnDelay = 20;
    public int minSpawnDelay = 200;
    public int maxSpawnDelay = 800;
    public int spawnCount = 4;
    public int maxNearbyEntities = 6;
    public int requiredPlayerRange = 16;
    public int spawnRange = 4;
    public EntityType<?> entityType;

    public EntityType<?> getEntityType() {
        return this.entityType;
    }

    public boolean isNearPlayer(Level pLevel, BlockPos pPos) {
        return pLevel.m_45914_((double)pPos.m_123341_() + 0.5, (double)pPos.m_123342_() + 0.5, (double)pPos.m_123343_() + 0.5, (double)this.requiredPlayerRange);
    }

    public void clientTick(Level pLevel, BlockPos pPos) {
    }

    public void serverTick(ServerLevel pServerLevel, BlockPos pPos) {
        if (this.getEntityType().m_20674_() == MobCategory.MONSTER && pServerLevel.m_46791_() == Difficulty.PEACEFUL) {
            return;
        }
        if (this.isNearPlayer((Level)pServerLevel, pPos)) {
            if (this.spawnDelay == -1) {
                this.delay((Level)pServerLevel, pPos);
            }
            if (this.spawnDelay > 0) {
                --this.spawnDelay;
            } else {
                RandomSource randomsource = pServerLevel.m_213780_();
                for (int i = 0; i < this.spawnCount; ++i) {
                    Entity entity = this.getEntityType().m_20615_((Level)pServerLevel);
                    if (entity == null) continue;
                    double d0 = (double)pPos.m_123341_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.spawnRange + 0.5;
                    double d1 = pPos.m_123342_() + randomsource.m_188503_(3) - 1;
                    double d2 = (double)pPos.m_123343_() + (randomsource.m_188500_() - randomsource.m_188500_()) * (double)this.spawnRange + 0.5;
                    entity.m_7678_(d0, d1, d2, 0.0f, 0.0f);
                    this.onEntityConfiguration(entity, pPos);
                    if (!pServerLevel.m_45772_(this.getEntityType().m_20585_(d0, d1, d2))) continue;
                    if (this.skipSpawnReason(pServerLevel)) {
                        this.delay((Level)pServerLevel, pPos);
                        return;
                    }
                    int k = pServerLevel.m_45976_(entity.getClass(), new AABB((double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (double)(pPos.m_123341_() + 1), (double)(pPos.m_123342_() + 1), (double)(pPos.m_123343_() + 1)).m_82400_((double)this.spawnRange)).size();
                    if (k >= this.maxNearbyEntities) {
                        this.delay((Level)pServerLevel, pPos);
                        return;
                    }
                    pServerLevel.m_7967_(entity);
                    this.onEntitySpawn(pServerLevel, entity, pPos);
                    this.delay((Level)pServerLevel, pPos);
                }
            }
        }
    }

    public boolean skipSpawnReason(ServerLevel pServerLevel) {
        return this.getEntityType().m_20674_().m_21609_() && pServerLevel.m_46791_() == Difficulty.PEACEFUL;
    }

    public abstract void onEntityConfiguration(Entity var1, BlockPos var2);

    public abstract void onEntitySpawn(ServerLevel var1, Entity var2, BlockPos var3);

    private void delay(Level pLevel, BlockPos pPos) {
        RandomSource randomsource = pLevel.f_46441_;
        this.spawnDelay = this.maxSpawnDelay <= this.minSpawnDelay ? this.minSpawnDelay : this.minSpawnDelay + randomsource.m_188503_(this.maxSpawnDelay - this.minSpawnDelay);
        this.broadcastEvent(pLevel, pPos, 1);
    }

    public void load(@Nullable Level pLevel, BlockPos pPos, CompoundTag pTag) {
        this.spawnDelay = pTag.m_128448_("Delay");
        if (pTag.m_128425_("MinSpawnDelay", 99)) {
            this.minSpawnDelay = pTag.m_128448_("MinSpawnDelay");
            this.maxSpawnDelay = pTag.m_128448_("MaxSpawnDelay");
            this.spawnCount = pTag.m_128448_("SpawnCount");
        }
        if (pTag.m_128425_("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = pTag.m_128448_("MaxNearbyEntities");
            this.requiredPlayerRange = pTag.m_128448_("RequiredPlayerRange");
        }
        if (pTag.m_128425_("SpawnRange", 99)) {
            this.spawnRange = pTag.m_128448_("SpawnRange");
        }
    }

    public CompoundTag save(CompoundTag pTag) {
        pTag.m_128376_("Delay", (short)this.spawnDelay);
        pTag.m_128376_("MinSpawnDelay", (short)this.minSpawnDelay);
        pTag.m_128376_("MaxSpawnDelay", (short)this.maxSpawnDelay);
        pTag.m_128376_("SpawnCount", (short)this.spawnCount);
        pTag.m_128376_("MaxNearbyEntities", (short)this.maxNearbyEntities);
        pTag.m_128376_("RequiredPlayerRange", (short)this.requiredPlayerRange);
        pTag.m_128376_("SpawnRange", (short)this.spawnRange);
        return pTag;
    }

    public boolean onEventTriggered(Level pLevel, int pId) {
        if (pId == 1) {
            if (pLevel.f_46443_) {
                this.spawnDelay = this.minSpawnDelay;
            }
            return true;
        }
        return false;
    }

    public abstract void broadcastEvent(Level var1, BlockPos var2, int var3);
}

