/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.entity.trades;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.BasicItemListing;

public class Trade {
    private final Int2ObjectMap<List<VillagerTrades.ItemListing>> trades;
    public TradeTier tier;
    public float multiplier;
    public int experience;
    public int maxTrades;

    public Trade(Int2ObjectMap<List<VillagerTrades.ItemListing>> trades) {
        this.trades = trades;
        this.maxTrades = 1;
        this.experience = 1;
        this.multiplier = 0.0f;
        this.tier = TradeTier.NOVICE;
    }

    public Trade tier(TradeTier tier) {
        this.tier = tier;
        return this;
    }

    public Trade trades(int max) {
        this.maxTrades = max;
        return this;
    }

    public Trade xp(int xp) {
        this.experience = xp;
        return this;
    }

    public Trade mul(float mul) {
        this.multiplier = mul;
        return this;
    }

    public void createSale(int pEmeralds, ItemLike item) {
        ((List)this.trades.get(this.tier.getLevel())).add(new BasicItemListing(new ItemStack(item, 1), new ItemStack((ItemLike)Items.f_42616_, pEmeralds), this.maxTrades, this.experience, this.multiplier));
    }

    public void createSale(int pEmeralds, ItemLike item, int count) {
        ((List)this.trades.get(this.tier.getLevel())).add(new BasicItemListing(new ItemStack(item, count), new ItemStack((ItemLike)Items.f_42616_, pEmeralds), this.maxTrades, this.experience, this.multiplier));
    }

    public void createOffer(int pEmeralds, ItemLike additional, ItemLike item) {
        ((List)this.trades.get(this.tier.getLevel())).add(new BasicItemListing(new ItemStack((ItemLike)Items.f_42616_, pEmeralds), new ItemStack(additional), new ItemStack(item), this.maxTrades, this.experience, this.multiplier));
    }

    public void createOffer(int pEmeralds, ItemLike item) {
        ((List)this.trades.get(this.tier.getLevel())).add(new BasicItemListing(pEmeralds, new ItemStack(item), this.maxTrades, this.experience, this.multiplier));
    }

    public void createListing(BasicItemListing listing) {
        ((List)this.trades.get(this.tier.getLevel())).add(listing);
    }

    public static enum TradeTier {
        NOVICE(1),
        APPRENTICE(2),
        JOURNEYMAN(3),
        EXPERT(4),
        MASTER(5);

        public final int level;

        private TradeTier(int level) {
            this.level = level;
        }

        public int getLevel() {
            return this.level;
        }
    }
}

