/*
 * Decompiled with CFR 0.152.
 */
package pro.komaru.tridot.api.capabilities;

import com.mojang.logging.LogUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import pro.komaru.tridot.api.capabilities.CapabilityEntry;
import pro.komaru.tridot.api.capabilities.CapabilityUtils;
import pro.komaru.tridot.util.struct.capability.CapProvider;
import pro.komaru.tridot.util.struct.data.Seq;
import pro.komaru.tridot.util.struct.data.Var;
import pro.komaru.tridot.util.struct.func.Prov;

@Mod.EventBusSubscriber
public class Capabilities {
    public static Seq<CapabilityEntry<?>> caps = Seq.with();
    private static final Var<String> tempMod = new Var<String>("");

    public static void begin(String modId) {
        Capabilities.tempMod.var = modId;
    }

    public static <T> CapabilityEntry<T> reg(String modId, String id, Prov<CapProvider> provider, Prov<Capability<T>> instance) {
        CapabilityEntry entry = new CapabilityEntry();
        entry.capId = id;
        entry.modId = modId;
        entry.prov = provider;
        entry.instance = instance;
        entry.id = Capabilities.caps.size;
        if (caps.contains(entry)) {
            LogUtils.getLogger().warn("Existing capability register: {}:{}", tempMod, (Object)id);
        }
        caps.addUnique(entry);
        return entry;
    }

    public static void close(String modId) {
        if (modId.equals(Capabilities.tempMod.var)) {
            Capabilities.tempMod.var = null;
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            for (CapabilityEntry<?> cap : caps) {
                event.addCapability(new ResourceLocation(cap.modId, cap.capId), (ICapabilityProvider)cap.prov.get());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        for (CapabilityEntry<?> cap : caps) {
            Capability CAP = cap.instance.get();
            event.getOriginal().reviveCaps();
            event.getEntity().getCapability(CAP).ifPresent(k -> event.getOriginal().getCapability(CAP).ifPresent(o -> {
                INBTSerializable kSer = (INBTSerializable)k;
                INBTSerializable oSer = (INBTSerializable)o;
                kSer.deserializeNBT((Tag)((CompoundTag)oSer.serializeNBT()));
            }));
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Capabilities.sync(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Capabilities.sync(event.getEntity());
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Capabilities.sync(event.getEntity());
    }

    public static void sync(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer s = (ServerPlayer)player;
            for (CapabilityEntry<?> cap : caps) {
                CapabilityUtils.get(player, cap, i -> i.sync(s));
            }
        }
    }
}

