/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.vintage_animations.mixin;

import dev.architectury.platform.Platform;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.pixeldreamstudios.vintage_animations.IAnimatedPlayer;
import net.pixeldreamstudios.vintage_animations.VintageAnimations;
import net.pixeldreamstudios.vintage_animations.compat.FirstPersonModelCompat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public class LivingEntityMixin {
    @Unique
    private ModifierLayer<IAnimation> vintageAnimations$animationContainer;
    @Unique
    private int vintageAnimations$ctr = 0;
    @Unique
    private boolean vintageAnimations$switchedMainHandLeft = false;
    @Unique
    private boolean vintageAnimations$switchedMainHandRight = true;

    @Inject(method={"swing(Lnet/minecraft/world/InteractionHand;)V"}, at={@At(value="HEAD")})
    private void playAnimation(InteractionHand interactionHand, CallbackInfo ci) {
        LivingEntity player = (LivingEntity)this;
        if (player instanceof Player && player.m_9236_().m_5776_()) {
            ItemStack itemStack = player.m_21120_(interactionHand);
            if (itemStack.m_204117_(ItemTags.f_271207_) && VintageAnimations.config.chopAnimation) {
                this.playAnim(player, "chop");
            } else if (itemStack.m_204117_(ItemTags.f_271360_) && VintageAnimations.config.pickAnimation) {
                this.playAnim(player, "pick");
            } else if (itemStack.m_204117_(ItemTags.f_271138_) && VintageAnimations.config.digAnimation) {
                this.playAnim(player, "dig");
            } else if (itemStack.m_204117_(ItemTags.f_271298_) && VintageAnimations.config.tillAnimation) {
                this.playAnim(player, "till");
            }
        }
    }

    @Inject(method={"getAttackAnim"}, at={@At(value="RETURN")}, cancellable=true)
    private void cancelVanillaAttackAnim(float f, CallbackInfoReturnable<Float> cir) {
        LivingEntity player = (LivingEntity)this;
        if (player instanceof Player && player.m_9236_().m_5776_() && this.vintageAnimations$animationContainer != null && this.vintageAnimations$animationContainer.getAnimation() != null && this.vintageAnimations$animationContainer.getAnimation().isActive()) {
            cir.setReturnValue((Object)Float.valueOf(0.0f));
        }
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void incrCtr(CallbackInfo ci) {
        LivingEntity player = (LivingEntity)this;
        if (player instanceof Player && player.m_9236_().m_5776_()) {
            if (this.vintageAnimations$animationContainer != null) {
                boolean vintageAnimations$mainHandLeft = ((HumanoidArm)Minecraft.m_91087_().f_91066_.m_232107_().m_231551_()).equals((Object)HumanoidArm.LEFT);
                if (vintageAnimations$mainHandLeft && !this.vintageAnimations$switchedMainHandLeft) {
                    this.vintageAnimations$animationContainer.addModifier((AbstractModifier)new MirrorModifier(true), 0);
                    this.vintageAnimations$switchedMainHandLeft = true;
                    this.vintageAnimations$switchedMainHandRight = false;
                } else if (!vintageAnimations$mainHandLeft && !this.vintageAnimations$switchedMainHandRight) {
                    this.vintageAnimations$animationContainer.removeModifier(0);
                    this.vintageAnimations$switchedMainHandRight = true;
                    this.vintageAnimations$switchedMainHandLeft = false;
                }
            }
            ++this.vintageAnimations$ctr;
            if (this.vintageAnimations$ctr >= 10000) {
                this.vintageAnimations$ctr = 0;
            }
        }
    }

    private void playAnim(LivingEntity player, String animName) {
        KeyframeAnimation anim = PlayerAnimationRegistry.getAnimation((ResourceLocation)new ResourceLocation("vintage_animations", animName));
        KeyframeAnimationPlayer animPlayer = new KeyframeAnimationPlayer(anim).setFirstPersonConfiguration(new FirstPersonConfiguration(VintageAnimations.config.showArmsInFirstPerson, VintageAnimations.config.showArmsInFirstPerson && VintageAnimations.config.showOffHandInFirstPerson, true, VintageAnimations.config.showOffHandInFirstPerson));
        animPlayer.setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL);
        this.compatCheck(animPlayer);
        this.vintageAnimations$animationContainer = ((IAnimatedPlayer)player).vintage_animations_getModAnimation();
        if (this.vintageAnimations$ctr >= anim.endTick) {
            this.vintageAnimations$animationContainer.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)5, (Ease)Ease.INOUTEXPO), (IAnimation)animPlayer, true);
            this.vintageAnimations$ctr = 0;
        }
    }

    private void compatCheck(KeyframeAnimationPlayer animPlayer) {
        if (Platform.isModLoaded((String)"firstperson")) {
            new FirstPersonModelCompat(animPlayer);
        }
        if (Platform.isModLoaded((String)"realcamera")) {
            animPlayer.setFirstPersonMode(FirstPersonMode.DISABLED);
        }
    }
}

