/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.world.feature;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Objects;
import net.builderdog.ancient_aether.data.resources.registries.features.AncientAetherMiscFeatures;
import net.builderdog.ancient_aether.world.processor.RemoveWaterloggingProcessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.ProcessorRule;
import net.minecraft.world.level.levelgen.structure.templatesystem.RandomBlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.jetbrains.annotations.NotNull;

public class DungeonEntranceFeature
extends Feature<NoneFeatureConfiguration> {
    public DungeonEntranceFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(@NotNull FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        int x = context.m_159777_().m_123341_();
        int y = context.m_159777_().m_123342_();
        int z = context.m_159777_().m_123343_();
        BlockPos pos = new BlockPos(x, y, z);
        BlockPos posOffset = new BlockPos(x - 5, y, z - 5);
        BlockPos posVoid = new BlockPos(x, y - 12, z);
        RandomSource random = context.m_225041_();
        if (level.m_46859_(pos)) {
            if (!level.m_46859_(posVoid) && !level.m_8055_(posVoid).m_204336_(AetherTags.Blocks.NON_BRONZE_DUNGEON_SPAWNABLE)) {
                StructureTemplate template = level.m_6018_().m_215082_().m_230359_(new ResourceLocation("ancient_aether", "bronze_dungeon/entrance/entrance"));
                template.m_230328_((ServerLevelAccessor)level, posOffset, pos, this.getSettings(), random, 3);
            }
        } else {
            StructureTemplate template = level.m_6018_().m_215082_().m_230359_(new ResourceLocation("ancient_aether", "bronze_dungeon/entrance/staircase"));
            ConfiguredFeature feature = (ConfiguredFeature)Objects.requireNonNull(level.m_9598_().m_175515_(Registries.f_256911_).m_203636_(AncientAetherMiscFeatures.BRONZE_DUNGEON_ENTRANCE).orElse(null)).m_203334_();
            ChunkGenerator chunk = level.m_6018_().m_7726_().m_8481_();
            template.m_230328_((ServerLevelAccessor)level, posOffset, pos, this.getSettings(), random, 3);
            feature.m_224953_(level, chunk, random, new BlockPos(x, y + 8, z));
        }
        return false;
    }

    protected StructurePlaceSettings getSettings() {
        StructurePlaceSettings placeSettings = new StructurePlaceSettings();
        placeSettings.m_74402_(true);
        placeSettings.m_74383_((StructureProcessor)new RuleProcessor((List)ImmutableList.of((Object)new ProcessorRule((RuleTest)new RandomBlockMatchTest((Block)AetherBlocks.CARVED_STONE.get(), 0.01f), (RuleTest)AlwaysTrueTest.f_73954_, ((Block)AetherBlocks.SENTRY_STONE.get()).m_49966_())))).m_74383_((StructureProcessor)new RemoveWaterloggingProcessor());
        return placeSettings;
    }
}

