/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.entity.projectile;

import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.effect.AetherEffects;
import com.aetherteam.aether.entity.projectile.crystal.AbstractCrystal;
import javax.annotation.Nullable;
import net.builderdog.ancient_aether.client.AncientAetherSoundEvents;
import net.builderdog.ancient_aether.entity.AncientAetherEntityTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class RemedyCrystal
extends AbstractCrystal {
    private double xPower;
    private double zPower;

    public RemedyCrystal(EntityType<? extends RemedyCrystal> entityType, Level level) {
        super(entityType, level);
    }

    public RemedyCrystal(Level level, Entity shooter) {
        this((EntityType<? extends RemedyCrystal>)((EntityType)AncientAetherEntityTypes.REMEDY_CRYSTAL.get()), level);
        this.m_5602_(shooter);
        this.m_6034_(shooter.m_20185_(), shooter.m_20186_(), shooter.m_20189_());
        float rotation = this.f_19796_.m_188501_() * 360.0f;
        this.xPower = (double)Mth.m_14031_((float)rotation) * 0.2;
        this.zPower = (double)(-Mth.m_14089_((float)rotation)) * 0.2;
        this.m_20334_(this.xPower, 0.0, this.zPower);
    }

    protected void m_8060_(@NotNull BlockHitResult result) {
        this.m_5834_();
        switch (result.m_82434_()) {
            case NORTH: 
            case SOUTH: {
                this.zPower = -this.zPower;
                break;
            }
            case WEST: 
            case EAST: {
                this.xPower = -this.xPower;
            }
        }
        this.m_20334_(this.xPower, 0.0, this.zPower);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        Entity attackerEntity = source.m_7640_();
        if (attackerEntity instanceof LivingEntity) {
            LivingEntity attacker = (LivingEntity)attackerEntity;
            attacker.m_7292_(new MobEffectInstance((MobEffect)AetherEffects.REMEDY.get(), 100, 0, false, false, true));
            this.m_6074_();
        }
        return false;
    }

    protected ParticleOptions getExplosionParticle() {
        return (ParticleOptions)AetherParticleTypes.FROZEN.get();
    }

    @Nullable
    public SoundEvent getImpactExplosionSoundEvent() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_REMEDY_CRYSTAL_EXPLODE.get();
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128347_("XSpeed", this.xPower);
        tag.m_128347_("ZSpeed", this.zPower);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.xPower = tag.m_128459_("XSpeed");
        this.zPower = tag.m_128459_("ZSpeed");
    }
}

