/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.entity.passive;

import com.aetherteam.aether.entity.ai.goal.EatAetherGrassGoal;
import com.aetherteam.aether.entity.ai.goal.FallingRandomStrollGoal;
import com.aetherteam.aether.entity.passive.AetherAnimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.builderdog.ancient_aether.AncientAetherTags;
import net.builderdog.ancient_aether.block.AncientAetherBlocks;
import net.builderdog.ancient_aether.client.AncientAetherSoundEvents;
import net.builderdog.ancient_aether.data.resources.AncientAetherLoot;
import net.builderdog.ancient_aether.entity.AncientAetherEntityTypes;
import net.builderdog.ancient_aether.entity.passive.WyndcapsAnimal;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.IForgeShearable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Fluffalo
extends WyndcapsAnimal
implements Shearable,
IForgeShearable {
    private static final EntityDataAccessor<Boolean> SHEARED = SynchedEntityData.m_135353_(Fluffalo.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int eatAnimationTick;
    private EatAetherGrassGoal eatBlockGoal;

    public Fluffalo(EntityType<? extends AetherAnimal> entityType, Level level) {
        super(entityType, level);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, false){

            protected double m_6639_(@NotNull LivingEntity entity) {
                return this.f_25540_.m_20205_() * this.f_25540_.m_20205_() + entity.m_20205_();
            }
        });
        this.eatBlockGoal = new EatAetherGrassGoal((Mob)this);
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_204132_(AncientAetherTags.Items.FLUFFALO_TEMPTATION_ITEMS), false));
        this.f_21345_.m_25352_(4, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(5, (Goal)this.eatBlockGoal);
        this.f_21345_.m_25352_(6, (Goal)new FallingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Nonnull
    public static AttributeSupplier.Builder m_21552_() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22282_, 2.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SHEARED, (Object)false);
    }

    @NotNull
    public InteractionResult m_6071_(Player playerEntity, @Nonnull InteractionHand hand) {
        ItemStack itemStack = playerEntity.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_42446_) && !this.m_6162_()) {
            playerEntity.m_5496_((SoundEvent)AncientAetherSoundEvents.ENTITY_FLUFFALO_MILK.get(), 1.0f, 1.0f);
            ItemStack itemStack1 = ItemUtils.m_41813_((ItemStack)itemStack, (Player)playerEntity, (ItemStack)Items.f_42455_.m_7968_());
            playerEntity.m_21008_(hand, itemStack1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public ResourceLocation m_7582_() {
        return this.isSheared() ? AncientAetherLoot.ENTITIES_FLUFFALO_SHEARED : this.m_6095_().m_20677_();
    }

    protected void m_8024_() {
        this.eatAnimationTick = this.eatBlockGoal.getEatAnimationTick();
        super.m_8024_();
    }

    public void m_8107_() {
        if (this.m_9236_().f_46443_) {
            this.eatAnimationTick = Math.max(0, this.eatAnimationTick - 1);
        }
        super.m_8107_();
    }

    public void m_8035_() {
        this.setSheared(false);
        if (this.m_6162_()) {
            this.m_146758_(60);
        }
    }

    protected float m_6431_(@NotNull Pose pose, EntityDimensions size) {
        return 0.95f * size.f_20378_;
    }

    public float getHeadEatPositionScale(float pos) {
        if (this.eatAnimationTick <= 0) {
            return -4.0f;
        }
        if (this.eatAnimationTick >= 4 && this.eatAnimationTick <= 36) {
            return -2.0f;
        }
        return this.eatAnimationTick < 4 ? ((float)this.eatAnimationTick - pos) / 4.0f : -((float)(this.eatAnimationTick - 40) - pos) / 4.0f;
    }

    public float getHeadEatAngleScale(float angle) {
        if (this.eatAnimationTick > 4 && this.eatAnimationTick <= 36) {
            float f = ((float)(this.eatAnimationTick - 4) - angle) / 32.0f;
            return 0.62831855f + 0.21991149f * Mth.m_14031_((float)(f * 28.7f));
        }
        return this.eatAnimationTick > 0 ? 0.62831855f : this.m_146909_() * ((float)Math.PI / 180);
    }

    public void m_7822_(byte id) {
        if (id == 10) {
            this.eatAnimationTick = 40;
        } else {
            super.m_7822_(id);
        }
    }

    public boolean isSheared() {
        return (Boolean)this.f_19804_.m_135370_(SHEARED);
    }

    public void setSheared(boolean setSheared) {
        this.f_19804_.m_135381_(SHEARED, (Object)setSheared);
    }

    public boolean m_6220_() {
        return this.m_6084_() && !this.isSheared() && !this.m_6162_();
    }

    public boolean isShearable(@Nonnull ItemStack item, Level world, BlockPos pos) {
        return this.m_6220_();
    }

    public void m_5851_(@NotNull SoundSource sound) {
        this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12344_, sound, 1.0f, 1.0f);
        this.setSheared(true);
        int i = 1 + this.f_19796_.m_188503_(3);
        for (int j = 0; j < i; ++j) {
            ItemEntity itementity = this.m_20000_((ItemLike)AncientAetherBlocks.FLUFFALO_WOOL.get(), 1);
            if (itementity == null) continue;
            itementity.m_20256_(itementity.m_20184_().m_82520_((double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f), (double)(this.f_19796_.m_188501_() * 0.05f), (double)((this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.1f)));
        }
    }

    @Nonnull
    public List<ItemStack> onSheared(@Nullable Player player, @Nonnull ItemStack item, Level world, BlockPos pos, int fortune) {
        world.m_6269_(null, (Entity)this, SoundEvents.f_12344_, player == null ? SoundSource.BLOCKS : SoundSource.PLAYERS, 1.0f, 1.0f);
        if (!world.f_46443_) {
            this.setSheared(true);
            int i = 1 + this.f_19796_.m_188503_(3);
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (int j = 0; j < i; ++j) {
                items.add(new ItemStack((ItemLike)AncientAetherBlocks.FLUFFALO_WOOL.get()));
            }
            return items;
        }
        return Collections.emptyList();
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(AncientAetherTags.Items.FLUFFALO_TEMPTATION_ITEMS);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel level, @NotNull AgeableMob ageableMob) {
        return (AgeableMob)((EntityType)AncientAetherEntityTypes.FLUFFALO.get()).m_20615_((Level)level);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("Sheared", this.isSheared());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.setSheared(tag.m_128471_("Sheared"));
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_FLUFFALO_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@Nonnull DamageSource damage) {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_FLUFFALO_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_FLUFFALO_DEATH.get();
    }

    protected float m_6121_() {
        return 0.4f;
    }
}

