/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.entity.monster;

import com.aetherteam.aether.block.AetherBlocks;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.builderdog.ancient_aether.client.AncientAetherSoundEvents;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import org.jetbrains.annotations.NotNull;

public class AeronauticLeaper
extends Slime {
    public static final EntityDataAccessor<Boolean> DATA_AWAKE_ID = SynchedEntityData.m_135353_(AeronauticLeaper.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public float timeSpotted = 0.0f;

    public AeronauticLeaper(EntityType<? extends AeronauticLeaper> entity, Level level) {
        super(entity, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new AttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new RandomDirectionGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new KeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, entity -> Math.abs(entity.m_20186_() - this.m_20186_()) <= 4.0));
    }

    @Nonnull
    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.8).m_22268_(Attributes.f_22281_, 6.0).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.025);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_AWAKE_ID, (Object)false);
    }

    public void m_7839_(int size, boolean resetHealth) {
    }

    public void m_142687_(@Nonnull Entity.RemovalReason reason) {
        this.m_142467_(reason);
        if (reason == Entity.RemovalReason.KILLED) {
            this.m_146850_(GameEvent.f_223707_);
        }
        this.invalidateCaps();
    }

    public boolean isAwake() {
        return (Boolean)this.f_19804_.m_135370_(DATA_AWAKE_ID);
    }

    public void setAwake(boolean awake) {
        this.f_19804_.m_135381_(DATA_AWAKE_ID, (Object)awake);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5788_(this.m_20185_(), this.m_20186_(), this.m_20189_(), 8.0, EntitySelector.f_20408_) != null) {
            if (!this.isAwake()) {
                if (this.timeSpotted >= 24.0f) {
                    this.setAwake(true);
                }
                this.timeSpotted += 1.0f;
            }
        } else {
            this.setAwake(false);
        }
        super.m_8119_();
    }

    @Nullable
    public SpawnGroupData m_6518_(@Nonnull ServerLevelAccessor level, @Nonnull DifficultyInstance difficulty, @Nonnull MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag tag) {
        this.m_7839_(1, true);
        this.m_21559_(false);
        return spawnData;
    }

    @Nonnull
    protected ResourceLocation m_7582_() {
        return this.m_6095_().m_20677_();
    }

    protected SoundEvent m_7975_(@Nonnull DamageSource damageSource) {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_AERONAUTIC_LEAPER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_AERONAUTIC_LEAPER_DEATH.get();
    }

    protected boolean m_7483_() {
        return this.m_21515_();
    }

    public void m_6123_(@NotNull Player entity) {
        if (this.m_7483_()) {
            this.m_33637_((LivingEntity)entity);
        }
    }

    @Nonnull
    protected SoundEvent m_7905_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_AERONAUTIC_LEAPER_JUMP.get();
    }

    @Nonnull
    protected SoundEvent m_7903_() {
        return (SoundEvent)AncientAetherSoundEvents.ENTITY_AERONAUTIC_LEAPER_JUMP.get();
    }

    @Nonnull
    public EntityDimensions m_6972_(@NotNull Pose pose) {
        return super.m_6972_(pose).m_20388_(1.758f);
    }

    @Nonnull
    protected ParticleOptions m_6300_() {
        return new BlockParticleOption(ParticleTypes.f_123794_, ((Block)AetherBlocks.AEROGEL.get()).m_49966_());
    }

    @Nonnull
    public EntityType<? extends AeronauticLeaper> m_6095_() {
        return super.m_6095_();
    }

    protected boolean m_8028_() {
        return true;
    }

    protected void m_6135_() {
        if (this.isAwake()) {
            Vec3 vec3 = this.m_20184_();
            this.m_20334_(vec3.f_82479_, 0.25, vec3.f_82481_);
            this.f_19812_ = true;
            ForgeHooks.onLivingJump((LivingEntity)this);
        }
    }

    public static class FloatGoal
    extends Slime.SlimeFloatGoal {
        private final AeronauticLeaper leaper;

        public FloatGoal(AeronauticLeaper leaper) {
            super((Slime)leaper);
            this.leaper = leaper;
        }

        public boolean m_8036_() {
            return this.leaper.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.leaper.isAwake() && super.m_8045_();
        }
    }

    public static class AttackGoal
    extends Slime.SlimeAttackGoal {
        private final AeronauticLeaper leaper;

        public AttackGoal(AeronauticLeaper leaper) {
            super((Slime)leaper);
            this.leaper = leaper;
        }

        public boolean m_8036_() {
            return this.leaper.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.leaper.isAwake() && super.m_8045_();
        }
    }

    public static class RandomDirectionGoal
    extends Slime.SlimeRandomDirectionGoal {
        private final AeronauticLeaper leaper;

        public RandomDirectionGoal(AeronauticLeaper leaper) {
            super((Slime)leaper);
            this.leaper = leaper;
        }

        public boolean m_8036_() {
            return this.leaper.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.leaper.isAwake() && super.m_8045_();
        }
    }

    public static class KeepOnJumpingGoal
    extends Slime.SlimeKeepOnJumpingGoal {
        private final AeronauticLeaper leaper;

        public KeepOnJumpingGoal(AeronauticLeaper leaper) {
            super((Slime)leaper);
            this.leaper = leaper;
        }

        public boolean m_8036_() {
            return this.leaper.isAwake() && super.m_8036_();
        }

        public boolean m_8045_() {
            return this.leaper.isAwake() && super.m_8045_();
        }
    }
}

