/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.data.resources.registries.features;

import com.aetherteam.aether.AetherTags;
import java.util.List;
import net.builderdog.ancient_aether.data.resources.AncientAetherFeatureStates;
import net.builderdog.ancient_aether.data.resources.registries.features.AncientAetherFeatureUtils;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;

public class AncientAetherOreFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> AEROGEL_BLOBS = AncientAetherFeatureUtils.registerKey("aerogel_blobs");
    public static final ResourceKey<ConfiguredFeature<?, ?>> WYND_ICE_BLOBS = AncientAetherFeatureUtils.registerKey("gravity_gravel_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> AETHER_QUARTZ_ORE = AncientAetherFeatureUtils.registerKey("aether_quartz_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VALKYRUM_ORE = AncientAetherFeatureUtils.registerKey("valkyrum_ore");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest holystone = new TagMatchTest(AetherTags.Blocks.HOLYSTONE);
        List<OreConfiguration.TargetBlockState> aerogelBlobs = List.of(OreConfiguration.m_161021_((RuleTest)holystone, (BlockState)AncientAetherFeatureStates.AEROGEL));
        List<OreConfiguration.TargetBlockState> wyndIceBlobs = List.of(OreConfiguration.m_161021_((RuleTest)holystone, (BlockState)AncientAetherFeatureStates.WYND_ICE));
        List<OreConfiguration.TargetBlockState> aetherQuartzOre = List.of(OreConfiguration.m_161021_((RuleTest)holystone, (BlockState)AncientAetherFeatureStates.AETHER_QUARTZ_ORE));
        List<OreConfiguration.TargetBlockState> valkyrumOre = List.of(OreConfiguration.m_161021_((RuleTest)holystone, (BlockState)AncientAetherFeatureStates.VALKYRUM_ORE));
        AncientAetherFeatureUtils.register(context, AEROGEL_BLOBS, Feature.f_65731_, new OreConfiguration(aerogelBlobs, 32, 0.0f));
        AncientAetherFeatureUtils.register(context, WYND_ICE_BLOBS, Feature.f_65731_, new OreConfiguration(wyndIceBlobs, 64, 0.0f));
        AncientAetherFeatureUtils.register(context, AETHER_QUARTZ_ORE, Feature.f_65731_, new OreConfiguration(aetherQuartzOre, 16, 0.0f));
        AncientAetherFeatureUtils.register(context, VALKYRUM_ORE, Feature.f_65731_, new OreConfiguration(valkyrumOre, 6, 0.5f));
    }
}

