/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.data.resources.registries;

import net.builderdog.ancient_aether.AncientAetherTags;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.util.valueproviders.UniformFloat;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.carver.CarverConfiguration;
import net.minecraft.world.level.levelgen.carver.CaveCarverConfiguration;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.carver.WorldCarver;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.heightproviders.UniformHeight;

public class AncientAetherConfiguredCarvers {
    public static final ResourceKey<ConfiguredWorldCarver<?>> AETHER_CAVE = AncientAetherConfiguredCarvers.createKey("aether_cave");
    public static final ResourceKey<ConfiguredWorldCarver<?>> AETHER_CAVE_ELEVATED = AncientAetherConfiguredCarvers.createKey("aether_cave_elevated");
    public static final ResourceKey<ConfiguredWorldCarver<?>> AETHER_CAVE_SAKURA = AncientAetherConfiguredCarvers.createKey("aether_cave_sakura");

    private static ResourceKey<ConfiguredWorldCarver<?>> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_257003_, (ResourceLocation)new ResourceLocation("ancient_aether", name));
    }

    private static ConfiguredWorldCarver<?> createBaseAetherCave(HolderGetter<Block> blocks, float probability, int minHeight) {
        CaveCarverConfiguration config = new CaveCarverConfiguration(probability, (HeightProvider)UniformHeight.m_162034_((VerticalAnchor)VerticalAnchor.m_158922_((int)minHeight), (VerticalAnchor)VerticalAnchor.m_158922_((int)256)), (FloatProvider)UniformFloat.m_146605_((float)0.6f, (float)1.2f), VerticalAnchor.m_158930_((int)-64), (HolderSet)blocks.m_254956_(AncientAetherTags.Blocks.AETHER_CARVER_REPLACEABLES), (FloatProvider)UniformFloat.m_146605_((float)1.0f, (float)2.5f), (FloatProvider)UniformFloat.m_146605_((float)0.75f, (float)1.5f), (FloatProvider)UniformFloat.m_146605_((float)-0.6f, (float)-0.2f));
        return new ConfiguredWorldCarver(WorldCarver.f_64974_, (CarverConfiguration)config);
    }

    public static void bootstrap(BootstapContext<ConfiguredWorldCarver<?>> context) {
        HolderGetter blocks = context.m_255420_(Registries.f_256747_);
        context.m_255272_(AETHER_CAVE, AncientAetherConfiguredCarvers.createBaseAetherCave((HolderGetter<Block>)blocks, 0.15f, 72));
        context.m_255272_(AETHER_CAVE_ELEVATED, AncientAetherConfiguredCarvers.createBaseAetherCave((HolderGetter<Block>)blocks, 0.15f, 88));
        context.m_255272_(AETHER_CAVE_SAKURA, AncientAetherConfiguredCarvers.createBaseAetherCave((HolderGetter<Block>)blocks, 0.2f, 0));
    }
}

