/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.data.providers;

import com.aetherteam.aether.block.dungeon.DoorwayBlock;
import com.aetherteam.aether.data.providers.AetherBlockStateProvider;
import java.util.Map;
import java.util.Objects;
import net.builderdog.ancient_aether.block.blocktype.AncientVaseBlock;
import net.builderdog.ancient_aether.block.blocktype.GrapeVineBlock;
import net.builderdog.ancient_aether.block.blocktype.SliderPrototypeBlock;
import net.builderdog.ancient_aether.block.blocktype.VaseBlock;
import net.builderdog.ancient_aether.block.blocktype.WindBlowerBlock;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LanternBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public abstract class AncientAetherBlockStateProvider
extends AetherBlockStateProvider {
    public AncientAetherBlockStateProvider(PackOutput output, String id, ExistingFileHelper helper) {
        super(output, id, helper);
    }

    public void blockWithItem(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    public void crossBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)((BlockModelBuilder)this.models().cross(Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey((Object)((Block)blockRegistryObject.get()))).m_135815_(), this.blockTexture((Block)blockRegistryObject.get()))).renderType("cutout"));
    }

    public void translucentDoorBlock(DoorBlock block, ResourceLocation bottom, ResourceLocation top) {
        this.doorBlockWithRenderType(block, bottom, top, "translucent");
    }

    public void translucentTrapdoorBlock(TrapDoorBlock block, ResourceLocation texture, boolean orientable) {
        this.trapdoorBlockWithRenderType(block, texture, orientable, "translucent");
    }

    public void AABookshelf(Block block, Block endBlock) {
        ModelBuilder bookshelf = this.models().cubeColumn(this.name(block), this.texture(this.name(block)), this.texture(this.name(endBlock)));
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)bookshelf)});
    }

    public void lantern(Block block) {
        BlockModelBuilder lantern = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.mcLoc("template_lantern"))).texture("lantern", this.texture(this.name(block)))).renderType("cutout");
        BlockModelBuilder hangingLantern = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent("hanging_" + this.name(block), this.mcLoc("template_hanging_lantern"))).texture("lantern", this.texture(this.name(block)))).renderType("cutout");
        this.getVariantBuilder(block).forAllStates(state -> ConfiguredModel.builder().modelFile((ModelFile)((Boolean)state.m_61143_((Property)LanternBlock.f_153459_) != false ? hangingLantern : lantern)).build());
    }

    public void carpet(Block block, Block baseBlock) {
        this.simpleBlock(block, (ModelFile)this.models().singleTexture(this.name(block), this.mcLoc("block/carpet"), "wool", this.texture(this.name(baseBlock))));
    }

    public void cornerBrick(Block block) {
        String blockName = this.name(block);
        ResourceLocation top = this.extend(this.texture(this.name(block)), "_top");
        ResourceLocation left = this.extend(this.texture(this.name(block)), "_right");
        ResourceLocation right = this.extend(this.texture(this.name(block)), "_left");
        ModelBuilder normal = ((BlockModelBuilder)this.models().cube(blockName, top, top, left, left, right, right)).texture("particle", top);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$cornerBrick$1((ModelFile)normal, arg_0), new Property[0]);
    }

    public void grapeVine(Block block) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int age = (Integer)state.m_61143_((Property)GrapeVineBlock.AGE);
            ModelBuilder vine = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_stage" + age, this.modLoc("block/template_grape_vine"))).texture("vine", this.texture(this.name(block) + "_stage" + age))).renderType("cutout_mipped");
            Direction direction = (Direction)state.m_61143_((Property)GrapeVineBlock.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)vine).rotationY((int)(direction.m_122435_() + 180.0f) % 360).build();
        }, new Property[0]);
    }

    public void slammrootPlant(Block block) {
        ModelBuilder plant = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.modLoc("block/template_slammroot_plant"))).texture("plant", this.texture(this.name(block)))).renderType("cutout_mipped");
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)plant)});
    }

    public void vase(Block block) {
        ModelBuilder vase = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.modLoc("block/template_vase"))).texture("vase", this.texture(this.name(block)))).renderType("cutout");
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$vase$3((ModelFile)vase, arg_0), new Property[0]);
    }

    public void ancientVase(Block block, Block blockCopy) {
        ModelBuilder ancientVase = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.modLoc("block/template_vase"))).texture("vase", this.texture(this.name(blockCopy)))).renderType("cutout");
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$ancientVase$4((ModelFile)ancientVase, arg_0), new Property[0]);
    }

    public BlockModelBuilder puffedBlock(String name, ResourceLocation down, ResourceLocation up, ResourceLocation north, ResourceLocation south, ResourceLocation east, ResourceLocation west) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.modLoc("template_puffed"))).texture("down", down)).texture("up", up)).texture("north", north)).texture("south", south)).texture("east", east)).texture("west", west);
    }

    public void windBlower(Block block) {
        String blockName = this.name(block);
        ResourceLocation down = this.extend(this.texture(this.name(block)), "_bottom");
        ResourceLocation up = this.extend(this.texture(this.name(block)), "_top");
        ResourceLocation north = this.extend(this.texture(this.name(block)), "_front");
        ResourceLocation south = this.extend(this.texture(this.name(block)), "_back");
        ResourceLocation east = this.extend(this.texture(this.name(block)), "_side_left");
        ResourceLocation west = this.extend(this.texture(this.name(block)), "_side_right");
        ResourceLocation down_puffed = this.extend(this.texture(this.name(block)), "_bottom_puffed");
        ResourceLocation up_puffed = this.extend(this.texture(this.name(block)), "_top_puffed");
        ResourceLocation north_puffed = this.extend(this.texture(this.name(block)), "_front_puffed");
        ResourceLocation south_puffed = this.extend(this.texture(this.name(block)), "_back_puffed");
        ResourceLocation east_puffed = this.extend(this.texture(this.name(block)), "_side_left_puffed");
        ResourceLocation west_puffed = this.extend(this.texture(this.name(block)), "_side_right_puffed");
        ModelBuilder normal = ((BlockModelBuilder)((BlockModelBuilder)this.models().cube(blockName, down, up, north, south, east, west)).renderType("translucent")).texture("particle", down);
        ModelBuilder puffed = ((BlockModelBuilder)this.puffedBlock(blockName + "_puffed", down_puffed, up_puffed, north_puffed, south_puffed, east_puffed, west_puffed).renderType("translucent")).texture("particle", down_puffed);
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$windBlower$5((ModelFile)puffed, (ModelFile)normal, arg_0), new Property[0]);
    }

    public void sliderPrototype(Block block) {
        ResourceLocation template = this.modLoc("block/template_slider_prototype");
        ModelBuilder normal = ((BlockModelBuilder)this.models().withExistingParent(this.name(block), template)).texture("slider", this.texture(this.name(block)));
        ModelBuilder critical = ((BlockModelBuilder)this.models().withExistingParent(this.name(block) + "_critical", template)).texture("slider", this.texture(this.name(block) + "_critical"));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$sliderPrototype$6((ModelFile)critical, (ModelFile)normal, arg_0), new Property[0]);
    }

    public void obelisk(Block block) {
        ModelBuilder obelisk = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.name(block), this.modLoc("block/template_obelisk"))).texture("obelisk", this.texture(this.name(block)))).renderType("translucent");
        this.getVariantBuilder(block).partialState().addModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)obelisk)});
    }

    public void AADungeonBlock(Block block, Block baseBlock) {
        ConfiguredModel dungeonBlock = new ConfiguredModel((ModelFile)this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock))));
        this.getVariantBuilder(block).partialState().setModels(new ConfiguredModel[]{dungeonBlock});
    }

    public void lockedMosaicBlock(RotatedPillarBlock block, RotatedPillarBlock baseBlock) {
        ModelFile.ExistingModelFile mosaicBlock = this.models().getExistingFile(this.modLoc("block/" + this.name((Block)baseBlock)));
        ModelFile.ExistingModelFile mosaicBlockHorizontal = this.models().getExistingFile(this.modLoc("block/" + this.name((Block)baseBlock) + "_horizontal"));
        this.getVariantBuilder((Block)block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$lockedMosaicBlock$7((ModelFile)mosaicBlockHorizontal, (ModelFile)mosaicBlock, arg_0), new Property[0]);
    }

    public void invisibleBlock(Block block, Block baseBlock) {
        ModelBuilder visible = this.models().cubeAll(this.name(baseBlock), new ResourceLocation("aether", "block/dungeon/" + this.name(baseBlock)));
        ModelBuilder invisible = this.models().getBuilder(this.name(block));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$invisibleBlock$8((ModelFile)visible, (ModelFile)invisible, arg_0), new Property[0]);
    }

    public void AAInvisibleBlock(Block block, Block baseBlock) {
        ModelBuilder visible = this.models().cubeAll(this.name(baseBlock), this.texture(this.name(baseBlock)));
        ModelBuilder invisible = this.models().getBuilder(this.name(block));
        this.getVariantBuilder(block).forAllStatesExcept(arg_0 -> AncientAetherBlockStateProvider.lambda$AAInvisibleBlock$9((ModelFile)visible, (ModelFile)invisible, arg_0), new Property[0]);
    }

    protected BlockModelBuilder makeWallPostModel(int width, int height, String name) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/block"))).element().from((float)(8 - width), 0.0f, (float)(8 - width)).to((float)(8 + width), (float)height, (float)(8 + width)).face(Direction.DOWN).texture("#top").cullface(Direction.DOWN).end().face(Direction.UP).texture("#top").cullface(Direction.UP).end().face(Direction.NORTH).texture("#side").end().face(Direction.SOUTH).texture("#side").end().face(Direction.WEST).texture("#side").end().face(Direction.EAST).texture("#side").end().end();
    }

    protected BlockModelBuilder makeWallSideModel(int length, int height, String name, ModelBuilder.FaceRotation faceRotation, int u1, int u2) {
        return (BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, this.mcLoc("block/block"))).element().from(5.0f, 0.0f, 0.0f).to(11.0f, (float)height, (float)length).face(Direction.DOWN).texture("#top").rotation(faceRotation).uvs((float)u1, 5.0f, (float)u2, 11.0f).cullface(Direction.DOWN).end().face(Direction.UP).texture("#top").rotation(faceRotation).uvs((float)u1, 5.0f, (float)u2, 11.0f).end().face(Direction.NORTH).texture("#side").cullface(Direction.NORTH).end().face(Direction.SOUTH).texture("#side").end().face(Direction.WEST).texture("#side").end().face(Direction.EAST).texture("#side").end().end();
    }

    public void logWallBlock(WallBlock block, Block baseBlock, String location, String modid, boolean postUsesTop, ModelFile postBig, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt, ModelFile sideShort, ModelFile sideAltShort, ModelFile sideTallShort, ModelFile sideTallAltShort) {
        this.logWallBlockInternal(block, this.name((Block)block), new ResourceLocation(modid, "block/" + location + this.name(baseBlock)), postUsesTop, postBig, postShort, postTall, side, sideAlt, sideTall, sideTallAlt, sideShort, sideAltShort, sideTallShort, sideTallAltShort);
    }

    private void logWallBlockInternal(WallBlock block, String baseName, ResourceLocation texture, boolean postUsesTop, ModelFile postBig, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt, ModelFile sideShort, ModelFile sideAltShort, ModelFile sideTallShort, ModelFile sideTallAltShort) {
        this.logWallBlock(this.getMultipartBuilder((Block)block), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_post_short")).parent(postShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_post_tall")).parent(postTall)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side")).parent(side)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_alt")).parent(sideAlt)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall")).parent(sideTall)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall_alt")).parent(sideTallAlt)).texture("particle", texture)).texture("top", texture)).texture("side", texture));
        this.logWallBlockWithPost(this.getMultipartBuilder((Block)block), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_post")).parent(postBig)).texture("particle", texture)).texture("top", (String)(postUsesTop ? texture + "_top" : texture.toString()))).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_short")).parent(sideShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_alt_short")).parent(sideAltShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall_short")).parent(sideTallShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(baseName + "_side_tall_alt_short")).parent(sideTallAltShort)).texture("particle", texture)).texture("top", texture)).texture("side", texture));
    }

    public void logWallBlock(MultiPartBlockStateBuilder builder, ModelFile postShort, ModelFile postTall, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt) {
        ((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(postShort).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.LOW}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.LOW}).end().end().part().modelFile(postTall).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.TALL}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.TALL}).end().end().part().modelFile(postShort).rotationY(90).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57951_, (Comparable[])new WallSide[]{WallSide.LOW}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57952_, (Comparable[])new WallSide[]{WallSide.LOW}).end().end().part().modelFile(postTall).rotationY(90).addModel()).nestedGroup().condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{false}).condition((Property)WallBlock.f_57950_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57951_, (Comparable[])new WallSide[]{WallSide.TALL}).condition((Property)WallBlock.f_57953_, (Comparable[])new WallSide[]{WallSide.NONE}).condition((Property)WallBlock.f_57952_, (Comparable[])new WallSide[]{WallSide.TALL}).end().end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).m_122434_().m_122479_()).forEach(e -> {
            this.logWallSidePart(builder, side, sideAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW, false);
            this.logWallSidePart(builder, sideTall, sideTallAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL, false);
        });
    }

    public void logWallBlockWithPost(MultiPartBlockStateBuilder builder, ModelFile postBig, ModelFile side, ModelFile sideAlt, ModelFile sideTall, ModelFile sideTallAlt) {
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(postBig).addModel()).condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{true}).end();
        WALL_PROPS.entrySet().stream().filter(e -> ((Direction)e.getKey()).m_122434_().m_122479_()).forEach(e -> {
            this.logWallSidePart(builder, side, sideAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.LOW, true);
            this.logWallSidePart(builder, sideTall, sideTallAlt, (Map.Entry<Direction, Property<WallSide>>)e, WallSide.TALL, true);
        });
    }

    private void logWallSidePart(MultiPartBlockStateBuilder builder, ModelFile model, ModelFile modelAlt, Map.Entry<Direction, Property<WallSide>> entry, WallSide height, boolean hasPost) {
        int rotation = ((int)entry.getKey().m_122435_() + 180) % 360;
        ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile(rotation < 180 ? model : modelAlt).rotationY(rotation).addModel()).condition(entry.getValue(), (Comparable[])new WallSide[]{height}).condition((Property)WallBlock.f_57949_, (Comparable[])new Boolean[]{hasPost});
    }

    private static /* synthetic */ ConfiguredModel[] lambda$AAInvisibleBlock$9(ModelFile visible, ModelFile invisible, BlockState state) {
        return (Boolean)state.m_61143_((Property)DoorwayBlock.INVISIBLE) == false ? ConfiguredModel.builder().modelFile(visible).build() : ConfiguredModel.builder().modelFile(invisible).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$invisibleBlock$8(ModelFile visible, ModelFile invisible, BlockState state) {
        return (Boolean)state.m_61143_((Property)DoorwayBlock.INVISIBLE) == false ? ConfiguredModel.builder().modelFile(visible).build() : ConfiguredModel.builder().modelFile(invisible).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$lockedMosaicBlock$7(ModelFile mosaicBlockHorizontal, ModelFile mosaicBlock, BlockState state) {
        Direction.Axis axis = (Direction.Axis)state.m_61143_((Property)RotatedPillarBlock.f_55923_);
        switch (axis) {
            case X: {
                return ConfiguredModel.builder().modelFile(mosaicBlockHorizontal).rotationX(90).rotationY(90).build();
            }
            case Y: {
                return ConfiguredModel.builder().modelFile(mosaicBlock).build();
            }
            case Z: {
                return ConfiguredModel.builder().modelFile(mosaicBlockHorizontal).rotationX(90).build();
            }
        }
        return ConfiguredModel.builder().build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$sliderPrototype$6(ModelFile critical, ModelFile normal, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)SliderPrototypeBlock.FACING);
        if (((Boolean)state.m_61143_((Property)SliderPrototypeBlock.CRITICAL)).booleanValue()) {
            switch (direction) {
                case NORTH: {
                    return ConfiguredModel.builder().modelFile(critical).build();
                }
                case EAST: {
                    return ConfiguredModel.builder().modelFile(critical).rotationY(90).build();
                }
                case SOUTH: {
                    return ConfiguredModel.builder().modelFile(critical).rotationY(180).build();
                }
                case WEST: {
                    return ConfiguredModel.builder().modelFile(critical).rotationY(270).build();
                }
            }
        } else {
            switch (direction) {
                case NORTH: {
                    return ConfiguredModel.builder().modelFile(normal).build();
                }
                case EAST: {
                    return ConfiguredModel.builder().modelFile(normal).rotationY(90).build();
                }
                case SOUTH: {
                    return ConfiguredModel.builder().modelFile(normal).rotationY(180).build();
                }
                case WEST: {
                    return ConfiguredModel.builder().modelFile(normal).rotationY(270).build();
                }
            }
        }
        return ConfiguredModel.builder().build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$windBlower$5(ModelFile puffed, ModelFile normal, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)WindBlowerBlock.FACING);
        if (((Boolean)state.m_61143_((Property)WindBlowerBlock.PUFFED)).booleanValue()) {
            switch (direction) {
                case NORTH: {
                    return ConfiguredModel.builder().modelFile(puffed).build();
                }
                case SOUTH: {
                    return ConfiguredModel.builder().modelFile(puffed).rotationY(180).build();
                }
                case WEST: {
                    return ConfiguredModel.builder().modelFile(puffed).rotationY(270).build();
                }
                case EAST: {
                    return ConfiguredModel.builder().modelFile(puffed).rotationY(90).build();
                }
            }
        } else {
            switch (direction) {
                case NORTH: {
                    return ConfiguredModel.builder().modelFile(normal).build();
                }
                case SOUTH: {
                    return ConfiguredModel.builder().modelFile(normal).rotationY(180).build();
                }
                case WEST: {
                    return ConfiguredModel.builder().modelFile(normal).rotationY(270).build();
                }
                case EAST: {
                    return ConfiguredModel.builder().modelFile(normal).rotationY(90).build();
                }
            }
        }
        return ConfiguredModel.builder().build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$ancientVase$4(ModelFile ancientVase, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)AncientVaseBlock.FACING);
        switch (direction) {
            case NORTH: {
                return ConfiguredModel.builder().modelFile(ancientVase).build();
            }
            case EAST: {
                return ConfiguredModel.builder().modelFile(ancientVase).rotationY(90).build();
            }
            case SOUTH: {
                return ConfiguredModel.builder().modelFile(ancientVase).rotationY(180).build();
            }
            case WEST: {
                return ConfiguredModel.builder().modelFile(ancientVase).rotationY(270).build();
            }
        }
        return ConfiguredModel.builder().build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$vase$3(ModelFile vase, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)VaseBlock.FACING);
        switch (direction) {
            case NORTH: {
                return ConfiguredModel.builder().modelFile(vase).build();
            }
            case EAST: {
                return ConfiguredModel.builder().modelFile(vase).rotationY(90).build();
            }
            case SOUTH: {
                return ConfiguredModel.builder().modelFile(vase).rotationY(180).build();
            }
            case WEST: {
                return ConfiguredModel.builder().modelFile(vase).rotationY(270).build();
            }
        }
        return ConfiguredModel.builder().build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$cornerBrick$1(ModelFile normal, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)WindBlowerBlock.FACING);
        switch (direction) {
            case NORTH: {
                return ConfiguredModel.builder().modelFile(normal).build();
            }
            case SOUTH: {
                return ConfiguredModel.builder().modelFile(normal).rotationY(180).build();
            }
            case WEST: {
                return ConfiguredModel.builder().modelFile(normal).rotationY(270).build();
            }
            case EAST: {
                return ConfiguredModel.builder().modelFile(normal).rotationY(90).build();
            }
        }
        return ConfiguredModel.builder().build();
    }
}

