/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.client.renderer;

import com.aetherteam.aether.capability.player.AetherPlayer;
import com.aetherteam.aether.client.renderer.accessory.GlovesRenderer;
import com.aetherteam.aether.client.renderer.accessory.PendantRenderer;
import com.aetherteam.aether.client.renderer.entity.model.CrystalModel;
import com.aetherteam.aether.client.renderer.entity.model.ValkyrieWingsModel;
import com.aetherteam.aether.client.renderer.player.layer.DartLayer;
import com.aetherteam.aether.entity.projectile.dart.GoldenDart;
import net.builderdog.ancient_aether.blockentity.AncientAetherBlockEntityTypes;
import net.builderdog.ancient_aether.client.renderer.AncientAetherModelLayers;
import net.builderdog.ancient_aether.client.renderer.accessory.ShieldRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.AeronauticDartRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.AeronauticLeaperRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.AncientAetherBoatRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.FestiveSwetRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.FluffaloRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.MutatedAechorNeedleRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.MutatedAechorPlantRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.RemedyCrystalRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.SlammrootRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.SporeBombRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.WindBlowRenderer;
import net.builderdog.ancient_aether.client.renderer.entity.model.AeronauticLeaperModel;
import net.builderdog.ancient_aether.client.renderer.entity.model.FestiveSwetModel;
import net.builderdog.ancient_aether.client.renderer.entity.model.FluffaloModel;
import net.builderdog.ancient_aether.client.renderer.entity.model.MutatedAechorPlantModel;
import net.builderdog.ancient_aether.client.renderer.entity.model.SlammrootModel;
import net.builderdog.ancient_aether.client.renderer.entity.model.SporeBombModel;
import net.builderdog.ancient_aether.client.renderer.player.layer.ValkyrumWingsLayer;
import net.builderdog.ancient_aether.entity.AncientAetherEntityTypes;
import net.builderdog.ancient_aether.entity.miscellaneous.AncientAetherBoatEntity;
import net.builderdog.ancient_aether.entity.projectile.AeronauticDart;
import net.builderdog.ancient_aether.item.AncientAetherItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.blockentity.CampfireRenderer;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.client.CuriosRendererRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class AncientAetherRenderers {
    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.BOAT.get(), context -> new AncientAetherBoatRenderer(context, false));
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.CHEST_BOAT.get(), context -> new AncientAetherBoatRenderer(context, true));
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.FLUFFALO.get(), FluffaloRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.FESTIVE_SWET.get(), FestiveSwetRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.SLAMMROOT.get(), SlammrootRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.AERONAUTIC_LEAPER.get(), AeronauticLeaperRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.MUTATED_AECHOR_PLANT.get(), MutatedAechorPlantRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.WIND_BLOW.get(), WindBlowRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.AERONAUTIC_DART.get(), AeronauticDartRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.MUTATED_AECHOR_NEEDLE.get(), MutatedAechorNeedleRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.SPORE_BOMB.get(), SporeBombRenderer::new);
        event.registerEntityRenderer((EntityType)AncientAetherEntityTypes.REMEDY_CRYSTAL.get(), RemedyCrystalRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)AncientAetherBlockEntityTypes.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)AncientAetherBlockEntityTypes.HANGING_SIGN.get(), HangingSignRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)AncientAetherBlockEntityTypes.CAMPFIRE.get(), CampfireRenderer::new);
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        for (AncientAetherBoatEntity.Type type : AncientAetherBoatEntity.Type.values()) {
            event.registerLayerDefinition(AncientAetherModelLayers.FLUFFALO, FluffaloModel::createBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.FESTIVE_SWET, FestiveSwetModel::createInnerBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.FESTIVE_SWET_OUTER, FestiveSwetModel::createOuterBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.SLAMMROOT, SlammrootModel::createBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.AERONAUTIC_LEAPER, AeronauticLeaperModel::createBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.MUTATED_AECHOR_PLANT, MutatedAechorPlantModel::createBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.SPORE_BOMB, SporeBombModel::createBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.REMEDY_CRYSTAL, CrystalModel::createBodyLayer);
            event.registerLayerDefinition(AncientAetherModelLayers.VALKYRUM_WINGS, () -> ValkyrieWingsModel.createMainLayer((float)3.5f, (float)3.375f));
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("ancient_aether", type.getModelLocation()), "main"), BoatModel::m_246613_);
            event.registerLayerDefinition(new ModelLayerLocation(new ResourceLocation("ancient_aether", type.getChestModelLocation()), "main"), ChestBoatModel::m_247175_);
        }
    }

    @SubscribeEvent
    public static void addPlayerLayers(EntityRenderersEvent.AddLayers event) {
        String[] types;
        EntityRenderDispatcher renderDispatcher = Minecraft.m_91087_().m_91290_();
        for (String type : types = new String[]{"default", "slim"}) {
            PlayerRenderer playerRenderer = (PlayerRenderer)event.getSkin(type);
            if (playerRenderer == null) continue;
            playerRenderer.m_115326_((RenderLayer)new DartLayer(renderDispatcher, (LivingEntityRenderer)playerRenderer, entity -> new AeronauticDart((EntityType<? extends GoldenDart>)((EntityType)AncientAetherEntityTypes.AERONAUTIC_DART.get()), entity.m_9236_()), AetherPlayer::getGoldenDartCount, 1.0f));
            playerRenderer.m_115326_(new ValkyrumWingsLayer(playerRenderer, Minecraft.m_91087_().m_167973_()));
        }
    }

    public static void registerCuriosRenderers() {
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.VALKYRUM_GLOVES.get()), GlovesRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.VALKYRUM_PENDANT.get()), PendantRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.HERMES_PENDANT.get()), PendantRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.WARRIOR_PENDANT.get()), PendantRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.GROWTH_PENDANT.get()), PendantRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.ANCIENT_PENDANT.get()), PendantRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.SHIELD_OF_INEBRIATION.get()), ShieldRenderer::new);
        CuriosRendererRegistry.register((Item)((Item)AncientAetherItems.SHIELD_OF_REMEDIATION.get()), ShieldRenderer::new);
    }
}

