/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.client.gui.screen;

import com.aetherteam.aether.AetherConfig;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.gui.component.menu.DynamicMenuButton;
import com.aetherteam.aether.client.gui.screen.menu.TitleScreenBehavior;
import com.aetherteam.aether.mixin.mixins.client.accessor.TitleScreenAccessor;
import com.aetherteam.cumulus.mixin.mixins.client.accessor.SplashRendererAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Objects;
import net.builderdog.ancient_aether.AncientAetherConfig;
import net.builderdog.ancient_aether.client.gui.component.AncientAetherMenuButton;
import net.builderdog.ancient_aether.client.gui.screen.AncientAetherModUpdateIndicator;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.renderer.CubeMap;
import net.minecraft.client.renderer.PanoramaRenderer;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.internal.BrandingControl;
import org.jetbrains.annotations.NotNull;

public class AncientAetherTitleScreen
extends TitleScreen
implements TitleScreenBehavior {
    private static final ResourceLocation PANORAMA_OVERLAY = new ResourceLocation("textures/gui/title/background/panorama_overlay.png");
    private static final ResourceLocation ANCIENT_AETHER_LOGO = new ResourceLocation("ancient_aether", "textures/gui/title/ancient_aether.png");
    private static final ResourceLocation THE_AETHER_LOGO = new ResourceLocation("ancient_aether", "textures/gui/title/the_aether.png");
    public static final Music MENU = new Music((Holder)AetherSoundEvents.MUSIC_MENU.getHolder().orElseThrow(), 20, 600, true);
    private final PanoramaRenderer panorama = new PanoramaRenderer(new CubeMap(new ResourceLocation("ancient_aether", "textures/gui/title/panorama/panorama")));
    private AncientAetherModUpdateIndicator modUpdateNotification;
    private boolean alignedLeft;
    private int rows;

    public AncientAetherTitleScreen() {
        ((TitleScreenAccessor)this).aether$setFading(true);
    }

    public AncientAetherTitleScreen(boolean alignedLeft) {
        this();
        this.alignedLeft = alignedLeft;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupButtons();
        this.modUpdateNotification = new AncientAetherModUpdateIndicator(this);
        this.modUpdateNotification.m_7856_();
    }

    public void setupButtons() {
        int buttonRows = 0;
        int lastY = 0;
        for (Renderable renderable : this.f_169369_) {
            if (!(renderable instanceof AbstractWidget)) continue;
            AbstractWidget abstractWidget = (AbstractWidget)renderable;
            Component buttonText = abstractWidget.m_6035_();
            if (TitleScreenBehavior.isImageButton((Component)buttonText)) {
                abstractWidget.f_93624_ = false;
            }
            if (!(abstractWidget instanceof AncientAetherMenuButton)) continue;
            AncientAetherMenuButton ancientAetherButton = (AncientAetherMenuButton)abstractWidget;
            if (this.isAlignedLeft()) {
                ++buttonRows;
            } else if (lastY < ancientAetherButton.originalY) {
                lastY = ancientAetherButton.originalY;
                ++buttonRows;
            }
            if (buttonText.equals(Component.m_237115_((String)"gui.aether.menu.server"))) {
                ancientAetherButton.serverButton = true;
                ancientAetherButton.buttonCountOffset = 2;
            } else {
                ancientAetherButton.buttonCountOffset = buttonRows;
            }
            if (!((Boolean)AetherConfig.CLIENT.enable_server_button.get()).booleanValue() || !buttonText.equals(Component.m_237115_((String)"menu.singleplayer"))) continue;
            ++buttonRows;
        }
        this.rows = this.alignedLeft ? buttonRows : buttonRows - 1;
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        TitleScreenAccessor titleScreenAccessor = (TitleScreenAccessor)this;
        if (this.f_96541_ != null && titleScreenAccessor.aether$getSplash() == null) {
            titleScreenAccessor.aether$setSplash(this.f_96541_.m_91310_().m_280369_());
        }
        float fadeAmount = super.handleFading(guiGraphics, (TitleScreen)this, titleScreenAccessor, this.panorama, PANORAMA_OVERLAY, partialTicks);
        float scale = AncientAetherTitleScreen.getScale(this, this.getMinecraft());
        if (((Boolean)AncientAetherConfig.CLIENT.the_aether_title.get()).booleanValue()) {
            this.setupLogoConfig(guiGraphics, fadeAmount, scale);
        } else {
            this.setupLogo(guiGraphics, fadeAmount, scale);
        }
        int roundedFadeAmount = Mth.m_14167_((float)(fadeAmount * 255.0f)) << 24;
        if ((roundedFadeAmount & 0xFC000000) != 0) {
            SplashRendererAccessor splashRendererAccessor;
            ForgeHooksClient.renderMainMenu((TitleScreen)this, (GuiGraphics)guiGraphics, (Font)this.f_96547_, (int)this.f_96543_, (int)this.f_96544_, (int)roundedFadeAmount);
            if (titleScreenAccessor.aether$getSplash() != null && (splashRendererAccessor = (SplashRendererAccessor)titleScreenAccessor.aether$getSplash()).cumulus$getSplash() != null && !splashRendererAccessor.cumulus$getSplash().isEmpty()) {
                PoseStack poseStack = guiGraphics.m_280168_();
                float splashX = this.alignedLeft ? 400.0f / scale : (float)this.f_96543_ / 2.0f + 175.0f / scale;
                float splashY = this.alignedLeft ? 100.0f / scale : (float)((int)(20.0f + 76.0f / scale));
                poseStack.m_85836_();
                poseStack.m_252880_(splashX, splashY, 0.0f);
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-20.0f));
                float textSize = 1.8f - Mth.m_14154_((float)(Mth.m_14031_((float)((float)(Util.m_137550_() % 1000L) / 1000.0f * ((float)Math.PI * 2))) * 0.1f));
                textSize = textSize * (120.0f / scale) / ((float)this.f_96547_.m_92895_(splashRendererAccessor.cumulus$getSplash()) + 64.0f / scale);
                poseStack.m_85841_(textSize, textSize, textSize);
                guiGraphics.m_280137_(this.f_96547_, splashRendererAccessor.cumulus$getSplash(), 0, (int)(-16.0f / scale), 0xF4CF97 | roundedFadeAmount);
                poseStack.m_85849_();
            }
            if (this.alignedLeft) {
                super.renderRightBranding(guiGraphics, (TitleScreen)this, this.f_96547_, roundedFadeAmount);
            } else {
                BrandingControl.forEachLine((boolean)true, (boolean)true, (brandingLine, branding) -> {
                    int n = brandingLine;
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280488_(this.f_96547_, branding, 2, this.f_96544_ - (10 + n * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
                });
                BrandingControl.forEachAboveCopyrightLine((brandingLine, branding) -> {
                    int n = this.f_96543_ - this.f_96547_.m_92895_(branding);
                    int n2 = brandingLine + 1;
                    Objects.requireNonNull(this.f_96547_);
                    guiGraphics.m_280488_(this.f_96547_, branding, n, this.f_96544_ - (10 + n2 * (9 + 1)), 0xFFFFFF | roundedFadeAmount);
                });
            }
        }
        int xOffset = super.handleButtonVisibility((TitleScreen)this, fadeAmount);
        for (Renderable renderable : this.f_169369_) {
            renderable.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            if (renderable instanceof AncientAetherMenuButton) {
                AncientAetherMenuButton ancientAetherButton = (AncientAetherMenuButton)renderable;
                if (ancientAetherButton.m_5953_(mouseX, mouseY)) {
                    if (ancientAetherButton.hoverOffset < 15) {
                        ancientAetherButton.hoverOffset += 4;
                    }
                } else if (ancientAetherButton.hoverOffset > 0) {
                    ancientAetherButton.hoverOffset -= 4;
                }
            }
            if (!(renderable instanceof DynamicMenuButton)) continue;
            DynamicMenuButton dynamicMenuButton = (DynamicMenuButton)renderable;
            if (!dynamicMenuButton.enabled) continue;
            xOffset -= 24;
        }
        super.handleImageButtons((TitleScreen)this, xOffset);
        if (fadeAmount >= 1.0f) {
            this.modUpdateNotification.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    private void setupLogo(GuiGraphics guiGraphics, float transparency, float scale) {
        int width = (int)(400.0f / scale);
        int height = (int)(75.0f / scale);
        int logoX = this.alignedLeft ? (int)(10.0f + 18.0f / scale) : (int)((float)(width / 2) - 175.0f / scale);
        int logoY = this.alignedLeft ? (int)(15.0f + 10.0f / scale) : (int)(25.0f + 10.0f / scale);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, transparency);
        guiGraphics.m_280163_(ANCIENT_AETHER_LOGO, logoX, logoY, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void setupLogoConfig(GuiGraphics guiGraphics, float transparency, float scale) {
        int width = (int)(375.0f / scale);
        int height = (int)(112.5 / (double)scale);
        int logoX = this.alignedLeft ? (int)(10.0f + 18.0f / scale) : (int)((float)(width / 2) - 175.0f / scale);
        int logoY = this.alignedLeft ? (int)(15.0f + 10.0f / scale) : (int)(25.0f + 10.0f / scale);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, transparency);
        guiGraphics.m_280163_(THE_AETHER_LOGO, logoX, logoY, 0.0f, 0.0f, width, height, width, height);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public static float getScale(AncientAetherTitleScreen screen, Minecraft minecraft) {
        int guiScale = minecraft.m_91268_().m_85385_(((Integer)minecraft.f_91066_.m_231928_().m_231551_()).intValue(), minecraft.m_91390_());
        return AncientAetherTitleScreen.calculateScale(screen, guiScale, guiScale - 1);
    }

    public static float calculateScale(AncientAetherTitleScreen screen, float guiScale, float lowerScale) {
        int range;
        float scale = 1.0f;
        if (guiScale > 1.0f) {
            scale = guiScale / lowerScale;
        }
        if ((range = AncientAetherMenuButton.totalHeightRange(screen.rows, scale)) > screen.f_96544_ && scale != 1.0f) {
            return AncientAetherTitleScreen.calculateScale(screen, guiScale, lowerScale - 1.0f);
        }
        return scale;
    }

    @NotNull
    protected <T extends GuiEventListener & Renderable> T m_142416_(@NotNull T renderable) {
        Button button;
        if (renderable instanceof Button && TitleScreenBehavior.isMainButton((Component)(button = (Button)renderable).m_6035_())) {
            AncientAetherMenuButton ancientAetherButton = new AncientAetherMenuButton(this, button);
            return (T)super.m_142416_((GuiEventListener)ancientAetherButton);
        }
        return (T)super.m_142416_(renderable);
    }

    public boolean isAlignedLeft() {
        return this.alignedLeft;
    }
}

