/*
 * Decompiled with CFR 0.152.
 */
package net.builderdog.ancient_aether.block.blocktype;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nullable;
import net.builderdog.ancient_aether.block.blocktype.VaseBlock;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AncientVaseBlock
extends VaseBlock {
    private final ResourceLocation vaseLootTable;
    private Vec3 position;

    public AncientVaseBlock(ResourceLocation vaseLootTable, BlockBehaviour.Properties properties) {
        super(properties);
        this.vaseLootTable = vaseLootTable;
    }

    public void m_6240_(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable BlockEntity blockEntity, @NotNull ItemStack tool) {
        super.m_6240_(level, player, pos, state, blockEntity, tool);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LootParams parameters = new LootParams.Builder(serverLevel).m_287286_(LootContextParams.f_81461_, (Object)state).m_287286_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_287286_(LootContextParams.f_81460_, (Object)this.position).m_287286_(LootContextParams.f_81455_, (Object)player).m_287235_(LootContextParamSets.f_81421_);
            LootTable lootTable = serverLevel.m_7654_().m_278653_().m_278676_(this.vaseLootTable);
            ObjectArrayList list = lootTable.m_287195_(parameters);
            for (ItemStack itemstack : list) {
                this.spawnAtLocation(itemstack, pos, level);
            }
        }
    }

    public void spawnAtLocation(ItemStack itemStack, BlockPos pos, Level level) {
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        if (!itemStack.m_41619_() || !level.f_46443_) {
            ItemEntity itementity = new ItemEntity(level, (double)x, (double)y + 0.5, (double)z, itemStack);
            itementity.m_32060_();
            level.m_7967_((Entity)itementity);
            AncientVaseBlock.spawnDustParticles(level, pos);
        }
    }

    public static void spawnDustParticles(Level level, BlockPos pos) {
        double x = (double)pos.m_123341_() + (double)(level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.125;
        double y = (double)pos.m_123342_() + (double)(level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.125;
        double z = (double)pos.m_123343_() + (double)(level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.125;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123759_, x, y, z, 3, 0.5, 0.75, 0.5, 0.0);
        }
    }
}

