/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.minersdelight.jei;

import com.sammy.minersdelight.MinersDelightMod;
import com.sammy.minersdelight.logic.CupConversionReloadListener;
import com.sammy.minersdelight.setup.MDBlocks;
import com.sammy.minersdelight.setup.MDItems;
import java.util.Arrays;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.utility.TextUtils;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CopperPotCookingRecipeCategory
implements IRecipeCategory<CookingPotRecipe> {
    public static final RecipeType<CookingPotRecipe> COOKING = RecipeType.create((String)"miners_delight", (String)"cooking", CookingPotRecipe.class);
    protected final IDrawable heatIndicator;
    protected final IDrawable timeIcon;
    protected final IDrawable expIcon;
    protected final IDrawableAnimated arrow;
    private final Component title = TextUtils.getTranslation((String)"jei.cooking", (Object[])new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    public CopperPotCookingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = MinersDelightMod.path("textures/gui/copper_pot.png");
        ResourceLocation fdBackgroundImage = new ResourceLocation("farmersdelight", "textures/gui/cooking_pot.png");
        this.background = helper.createDrawable(backgroundImage, 29, 16, 117, 57);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)MDBlocks.COPPER_POT.get()));
        this.heatIndicator = helper.createDrawable(backgroundImage, 176, 0, 17, 15);
        this.timeIcon = helper.createDrawable(fdBackgroundImage, 176, 32, 8, 11);
        this.expIcon = helper.createDrawable(fdBackgroundImage, 176, 43, 9, 9);
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 15, 29, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<CookingPotRecipe> getRecipeType() {
        return COOKING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CookingPotRecipe recipe, IFocusGroup focuses) {
        ItemStack mealContainerStack;
        NonNullList recipeIngredients = recipe.m_7527_();
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 2; ++column) {
                int inputIndex = row * 2 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, 11 + column * borderSlotSize, 2 + row * borderSlotSize).addItemStacks(Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).m_43908_()));
            }
        }
        ItemStack resultStack = recipe.m_8043_(Minecraft.m_91087_().f_91073_.m_9598_());
        boolean cupServed = CupConversionReloadListener.BOWL_TO_CUP.containsKey(resultStack.m_41720_());
        ItemStack itemStack = mealContainerStack = cupServed ? MDItems.COPPER_CUP.asStack() : recipe.getOutputContainer();
        if (cupServed) {
            Item cupItem = CupConversionReloadListener.BOWL_TO_CUP.get(resultStack.m_41720_());
            ItemStack cupResultStack = new ItemStack((ItemLike)cupItem, Math.min(resultStack.m_41613_() * 2, cupItem.getMaxStackSize(cupItem.m_7968_())));
            cupResultStack.m_41751_(resultStack.m_41783_());
            resultStack = cupResultStack;
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 12).addItemStack(resultStack);
        if (!mealContainerStack.m_41619_()) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 54, 40).addItemStack(mealContainerStack);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 86, 40).addItemStack(resultStack);
    }

    public void draw(CookingPotRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.arrow.draw(guiGraphics, 48, 11);
        this.heatIndicator.draw(guiGraphics, 19, 40);
        this.timeIcon.draw(guiGraphics, 58, 4);
        if (recipe.getExperience() > 0.0f) {
            this.expIcon.draw(guiGraphics, 57, 23);
        }
    }
}

