/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.mixins.forge.alexsmobs;

import com.github.alexthe666.alexsmobs.entity.EntityCrow;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tech.alexnijjar.golemoverhaul.common.entities.golems.HayGolem;

@Mixin(value={EntityCrow.class})
public abstract class EntityCrowMixin {
    @Inject(method={"registerGoals"}, at={@At(value="TAIL")})
    private void registerGoals(CallbackInfo ci) {
        EntityCrow mob = (EntityCrow)this;
        mob.f_21345_.m_25352_(1, (Goal)new AIAvoidHayGolems(mob));
    }

    private static class AIAvoidHayGolems
    extends Goal {
        private final EntityCrow mob;
        @Nullable
        private HayGolem toAvoid;
        private final float maxDist = 16.0f;
        private int runDelay = 70;
        private Vec3 flightTarget;
        private final TargetingConditions avoidEntityTargeting;

        private AIAvoidHayGolems(EntityCrow mob) {
            this.mob = mob;
            this.avoidEntityTargeting = TargetingConditions.m_148352_().m_26883_(16.0);
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8045_() {
            return this.toAvoid != null && this.isCloseToTarget(16.0);
        }

        public boolean isCloseToTarget(double dist) {
            if (this.toAvoid == null) {
                return false;
            }
            return this.mob.m_20238_(this.toAvoid.m_20182_()) < dist * dist;
        }

        public boolean m_8036_() {
            if (this.mob.m_21824_()) {
                return false;
            }
            if (this.runDelay > 0) {
                --this.runDelay;
                return false;
            }
            this.runDelay = 70 + this.mob.m_217043_().m_188503_(150);
            float maxDistVertically = 12.0f;
            this.toAvoid = (HayGolem)this.mob.m_9236_().m_45982_(this.mob.m_9236_().m_6443_(HayGolem.class, this.mob.m_20191_().m_82377_(16.0, (double)maxDistVertically, 16.0), arg -> true), this.avoidEntityTargeting, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
            return this.toAvoid != null;
        }

        public void m_8056_() {
            if (this.toAvoid == null) {
                return;
            }
            this.mob.fleePumpkinFlag = 200;
            Vec3 vec = this.mob.getBlockInViewAway(this.toAvoid.m_20182_(), 10.0f);
            if (vec != null) {
                this.flightTarget = vec;
                this.mob.setFlying(true);
                this.mob.m_21566_().m_6849_(vec.f_82479_, vec.f_82480_, vec.f_82481_, 1.0);
            }
        }

        public void m_8037_() {
            Vec3 vec;
            if (this.toAvoid == null) {
                return;
            }
            if (!this.isCloseToTarget(16.0)) {
                return;
            }
            this.mob.fleePumpkinFlag = 200;
            if ((this.flightTarget == null || this.mob.m_20238_(this.flightTarget) < 2.0) && (vec = this.mob.getBlockInViewAway(this.toAvoid.m_20182_(), 10.0f)) != null) {
                this.flightTarget = vec;
                this.mob.setFlying(true);
            }
            if (this.flightTarget != null) {
                this.mob.m_21566_().m_6849_(this.flightTarget.f_82479_, this.flightTarget.f_82480_, this.flightTarget.f_82481_, 1.0);
            }
        }

        public void m_8041_() {
            this.flightTarget = null;
        }
    }
}

