/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class SlimeGolem
extends BaseGolem {
    private static final EntityDataAccessor<Byte> ID_SIZE = SynchedEntityData.m_135353_(SlimeGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDimensions SMALL_DIMENSIONS = EntityDimensions.m_20395_((float)0.5f, (float)0.5f);
    @NotNull
    private RawAnimation attackArm = this.getRandomArmAnimation();

    public SlimeGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, (double)Size.LARGE.health).m_22268_(Attributes.f_22279_, Size.LARGE.speed).m_22268_(Attributes.f_22282_, Size.LARGE.knockback).m_22268_(Attributes.f_22281_, (double)Size.LARGE.attackDamage);
    }

    @Override
    public AnimationController<?> getMovementController() {
        return super.getMovementController().setSoundKeyframeHandler(event -> this.m_9236_().m_245747_(this.m_20183_(), this.getStepSound(), this.m_5720_(), 0.3f, 1.0f, false));
    }

    public static boolean checkSlimeSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        boolean isSlimeChunk;
        if (!GolemOverhaulConfig.spawnSlimeGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        if (spawnType == MobSpawnType.SPAWNER) {
            return Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
        }
        if (level.m_204166_(pos).m_203656_(BiomeTags.f_215815_) && pos.m_123342_() > 50 && pos.m_123342_() < 70 && random.m_188501_() < 0.5f && random.m_188501_() < level.m_46940_() && level.m_46803_(pos) <= random.m_188503_(8)) {
            return SlimeGolem.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
        }
        if (!(level instanceof WorldGenLevel)) {
            return false;
        }
        ChunkPos chunkpos = new ChunkPos(pos);
        boolean bl = isSlimeChunk = WorldgenRandom.m_224681_((int)chunkpos.f_45578_, (int)chunkpos.f_45579_, (long)((WorldGenLevel)level).m_7328_(), (long)987234911L).m_188503_(10) == 0;
        if (random.m_188503_(10) == 0 && isSlimeChunk && pos.m_123342_() < 40) {
            return Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
        }
        return false;
    }

    @Override
    public PlayState getAttackAnimation(AnimationState<? extends BaseGolem> state) {
        return state.setAndContinue(this.attackArm);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_SIZE, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128359_("Size", this.getSize().name().toLowerCase(Locale.ROOT));
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        String sizeStr = compound.m_128461_("Size").toUpperCase(Locale.ROOT);
        if (sizeStr.isEmpty()) {
            this.setSize(Size.LARGE, false);
        } else {
            this.setSize(Size.valueOf(sizeStr), false);
        }
    }

    public Size getSize() {
        return Size.values()[(Byte)this.f_19804_.m_135370_(ID_SIZE)];
    }

    public void setSize(Size size, boolean resetHealth) {
        this.f_19804_.m_135381_(ID_SIZE, (Object)((byte)size.ordinal()));
        this.m_20090_();
        this.m_6210_();
        this.m_21051_(Attributes.f_22276_).m_22100_((double)size.health);
        this.m_21051_(Attributes.f_22279_).m_22100_(size.speed);
        this.m_21051_(Attributes.f_22282_).m_22100_(size.knockback);
        this.m_21051_(Attributes.f_22281_).m_22100_((double)size.attackDamage);
        if (resetHealth) {
            this.m_21153_(this.m_21233_());
        }
        this.f_21364_ = size.xpReward;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return this.getSize().isLarge() ? SoundEvents.f_12386_ : SoundEvents.f_12468_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return this.getSize().isLarge() ? SoundEvents.f_12385_ : SoundEvents.f_12467_;
    }

    private SoundEvent getStepSound() {
        return this.getSize().isLarge() ? SoundEvents.f_12386_ : SoundEvents.f_12468_;
    }

    @Override
    public boolean m_7327_(@NotNull Entity target) {
        if (super.m_7327_(target)) {
            this.m_5496_(this.getSize().isLarge() ? SoundEvents.f_12388_ : SoundEvents.f_12470_, 1.0f, 1.0f);
            return true;
        }
        return false;
    }

    @Override
    public int getAttackTicks() {
        return 22;
    }

    @Override
    public Item getRepairItem() {
        return Items.f_42518_;
    }

    @Override
    public float getRepairItemHealAmount() {
        return 10.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return SoundEvents.f_12389_;
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (!this.m_9236_().f_46443_ && this.getSize().isLarge() && this.m_21224_()) {
            Component name = this.m_7770_();
            boolean noAi = this.m_21525_();
            float width = this.m_6972_((Pose)this.m_20089_()).f_20377_;
            float halfWidth = width / 2.0f;
            int amount = 2 + this.f_19796_.m_188503_(3);
            for (int i = 0; i < amount; ++i) {
                float x = ((float)(i % 2) - 0.5f) * halfWidth;
                float z = ((float)(i / 2) - 0.5f) * halfWidth;
                SlimeGolem slime = (SlimeGolem)((EntityType)ModEntityTypes.SLIME_GOLEM.get()).m_20615_(this.m_9236_());
                if (slime == null) continue;
                if (this.m_21532_()) {
                    slime.m_21530_();
                }
                slime.m_6593_(name);
                slime.m_21557_(noAi);
                slime.m_20331_(this.m_20147_());
                slime.setSize(Size.SMALL, true);
                slime.m_7678_(this.m_20185_() + (double)x, this.m_20186_() + 0.5, this.m_20189_() + (double)z, this.f_19796_.m_188501_() * 360.0f, 0.0f);
                this.m_9236_().m_7967_((Entity)slime);
            }
        }
        super.m_142687_(reason);
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setSize(level.m_213780_().m_188499_() ? Size.LARGE : Size.SMALL, true);
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (pose == Pose.SLEEPING) {
            return f_20910_;
        }
        if (this.getSize().isLarge()) {
            return super.m_6972_(pose);
        }
        return SMALL_DIMENSIONS.m_20388_(this.m_6134_());
    }

    @Override
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 4) {
            this.attackArm = this.getRandomArmAnimation();
        }
    }

    private RawAnimation getRandomArmAnimation() {
        return this.m_217043_().m_188499_() ? ConstantAnimations.ATTACK_RIGHT : ConstantAnimations.ATTACK_LEFT;
    }

    @Override
    protected AABB getAttackBoundingBox() {
        return super.getAttackBoundingBox().m_82377_(0.5, 0.0, 0.5);
    }

    public static enum Size {
        LARGE(50, 6, 0.24, 2.0, 0),
        SMALL(20, 3, 0.19, 1.0, 6);

        private final int health;
        private final int attackDamage;
        private final double speed;
        private final double knockback;
        private final int xpReward;

        private Size(int health, int attackDamage, double speed, double knockback, int xpReward) {
            this.health = health;
            this.attackDamage = attackDamage;
            this.speed = speed;
            this.knockback = knockback;
            this.xpReward = xpReward;
        }

        public boolean isLarge() {
            return this == LARGE;
        }
    }
}

