/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.common.entities.golems;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.PlayState;
import tech.alexnijjar.golemoverhaul.common.config.GolemOverhaulConfig;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantAnimations;
import tech.alexnijjar.golemoverhaul.common.entities.golems.base.BaseGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModSoundEvents;

public class BarrelGolem
extends BaseGolem {
    private static final EntityDataAccessor<Boolean> ID_OPEN = SynchedEntityData.m_135353_(BarrelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ID_DAY_START_TICKS = SynchedEntityData.m_135353_(BarrelGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final Vec3i ITEM_PICKUP_REACH = new Vec3i(2, 0, 2);
    public static final ResourceLocation BARTERING_LOOT = new ResourceLocation("golemoverhaul", "gameplay/barrel_golem_bartering");
    public static final byte CHANGE_STATE_EVENT_ID = 8;
    public static final byte BARTER_EVENT_ID = 9;
    public static final int WAKE_UP_TICKS = 62;
    public static final int BARTERING_TICKS = 78;
    private int changeStateTicks;
    private int barteringTicks;
    private int openUpTicks;
    @Nullable
    private Player barteringTarget;

    public BarrelGolem(EntityType<? extends AbstractGolem> type, Level level) {
        super(type, level);
        this.f_21364_ = 10;
        this.m_21553_(true);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.31).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22281_, 1.0);
    }

    public static boolean checkMobSpawnRules(EntityType<? extends Mob> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        if (!GolemOverhaulConfig.spawnBarrelGolems || !GolemOverhaulConfig.allowSpawning) {
            return false;
        }
        return Mob.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    @Override
    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        super.registerControllers(controllers);
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "open_controller", state -> {
            if (this.isBartering()) {
                state.resetCurrentAnimation();
                return PlayState.STOP;
            }
            if (this.isWakingUp()) {
                return state.setAndContinue(ConstantAnimations.WAKE_UP);
            }
            if (this.openUpTicks > 0) {
                return state.setAndContinue(ConstantAnimations.OPEN);
            }
            if (this.m_9236_().m_46462_() || !this.isOpen()) {
                return state.setAndContinue(ConstantAnimations.HIDE);
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        })});
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, "barter_controller", 5, state -> {
            if (this.isBartering()) {
                return state.setAndContinue(ConstantAnimations.BARTER);
            }
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }).setSoundKeyframeHandler(event -> this.m_9236_().m_245747_(this.m_20183_(), (SoundEvent)ModSoundEvents.BARREL_GOLEM_BARTER.get(), this.m_5720_(), 1.0f, 1.0f, false))});
    }

    @Override
    public PlayState getMoveAnimation(AnimationState<BaseGolem> state, boolean moving) {
        if (!this.isOpen()) {
            return PlayState.STOP;
        }
        if (this.isBartering()) {
            state.resetCurrentAnimation();
            return PlayState.STOP;
        }
        return state.setAndContinue(moving ? ConstantAnimations.WALK : (this.isOpen() ? ConstantAnimations.IDLE : ConstantAnimations.IDLE_HIDDEN));
    }

    @Override
    public PlayState getAttackAnimation(AnimationState<? extends BaseGolem> state) {
        return PlayState.STOP;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_OPEN, (Object)true);
        this.f_19804_.m_135372_(ID_DAY_START_TICKS, (Object)62);
    }

    public boolean m_5829_() {
        return this.m_6084_() && !this.isOpen();
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Open", this.isOpen());
        compound.m_128405_("ChangeStateTicks", this.changeStateTicks);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setOpen(compound.m_128471_("Open"), false);
        this.changeStateTicks = compound.m_128451_("ChangeStateTicks");
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new BarrelGolemPanicGoal(1.0));
        this.f_21345_.m_25352_(2, (Goal)new BarrelGolemFindNearestEmeraldGoal());
    }

    @Override
    public boolean canTarget() {
        return false;
    }

    public boolean isOpen() {
        return (Boolean)this.f_19804_.m_135370_(ID_OPEN);
    }

    public boolean isBartering() {
        return this.barteringTicks > 0;
    }

    public int getBarteringTicks() {
        return this.barteringTicks;
    }

    public int getDayStartTicks() {
        return (Integer)this.f_19804_.m_135370_(ID_DAY_START_TICKS);
    }

    public void setDayStartTicks(int ticks) {
        this.f_19804_.m_135381_(ID_DAY_START_TICKS, (Object)ticks);
    }

    public void setOpen(boolean open, boolean playSound) {
        if (!open && this.m_6060_()) {
            return;
        }
        if (!this.m_9236_().m_5776_() && playSound && this.isOpen() != open) {
            if (open) {
                this.m_216990_(SoundEvents.f_11725_);
            } else {
                this.m_216990_(SoundEvents.f_11724_);
            }
        }
        this.f_19804_.m_135381_(ID_OPEN, (Object)open);
        this.openUpTicks = open ? 10 : 0;
        this.m_21051_(Attributes.f_22278_).m_22100_(open ? 0.0 : 1.0);
    }

    @Override
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12415_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12601_;
    }

    @Override
    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 8) {
            this.changeStateTicks = this.getRandomChangeInterval();
        } else if (id == 9) {
            this.barteringTicks = 78;
        }
    }

    @Override
    public boolean canRepair(ItemStack stack) {
        return stack.m_204117_(ItemTags.f_13168_);
    }

    @Override
    public float getRepairItemHealAmount() {
        return 5.0f;
    }

    @Override
    public SoundEvent getRepairSound() {
        return SoundEvents.f_11688_;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag dataTag) {
        this.setOpen(this.m_9236_().m_7445_() < 4, false);
        this.changeStateTicks = this.getRandomChangeInterval();
        return super.m_6518_(level, difficulty, reason, spawnData, dataTag);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.isOpen()) {
            AbstractArrow arrow;
            Entity entity = source.m_7640_();
            if (entity instanceof AbstractArrow && !(arrow = (AbstractArrow)entity).m_6060_()) {
                return false;
            }
            if (!source.m_269533_(DamageTypeTags.f_268745_)) {
                amount /= 10.0f;
            } else {
                amount *= 2.0f;
                if (!this.isOpen()) {
                    this.setOpen(true, true);
                }
            }
        }
        return super.m_6469_(source, amount);
    }

    protected boolean m_6107_() {
        return super.m_6107_() || this.isBartering() || !this.isOpen();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            if (this.m_9236_().m_7445_() < 4) {
                this.setDayStartTicks(this.getDayStartTicks() + 1);
            } else {
                this.setDayStartTicks(0);
            }
        }
        this.changeStateTicks = Math.max(0, this.changeStateTicks - 1);
        this.barteringTicks = Math.max(0, this.barteringTicks - 1);
        this.openUpTicks = Math.max(0, this.openUpTicks - 1);
        if (!this.m_9236_().m_5776_()) {
            if (this.changeStateTicks == 0 && this.m_9236_().m_46461_() && !this.isWakingUp()) {
                this.setOpen(!this.isOpen(), true);
                this.changeStateTicks = this.getRandomChangeInterval();
                this.m_9236_().m_7605_((Entity)this, (byte)8);
            }
            if (!this.isOpen() || this.isBartering()) {
                this.f_21344_.m_26573_();
            }
            if (!this.m_9236_().m_46461_() && this.isOpen()) {
                this.setOpen(false, true);
            } else if (this.finishedWakeUp() && !this.isOpen()) {
                this.setOpen(true, false);
            }
            if (this.barteringTicks == 24) {
                this.throwItems(this.getBarterResponseItems());
                ExperienceOrb orb = new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_217043_().m_188503_(2) + 2);
                this.m_9236_().m_7967_((Entity)orb);
                if (this.barteringTarget != null) {
                    Vec3 targetPos = this.barteringTarget.m_20182_().m_82546_(this.m_20182_());
                    targetPos = targetPos.m_82541_().m_82542_(0.3, 0.3, 0.3);
                    orb.m_20256_(targetPos);
                }
                this.barteringTarget = null;
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                this.m_146926_(0.0f);
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            if (!this.isOpen() || this.isBartering()) {
                this.f_20883_ = this.f_20885_;
            }
        } else {
            ItemStack stack = this.m_21205_();
            if (stack.m_150930_(Items.f_42616_) && !this.isBartering() && this.isOpen()) {
                this.barter();
            }
        }
    }

    protected void m_7581_(ItemEntity itemEntity) {
        Entity entity;
        ItemStack stack = itemEntity.m_32055_();
        ItemStack equippedStack = this.m_255207_(stack.m_41777_());
        if (!equippedStack.m_41619_()) {
            this.m_21053_(itemEntity);
            this.m_7938_((Entity)itemEntity, 1);
            stack.m_41774_(1);
            if (stack.m_41619_()) {
                itemEntity.m_146870_();
            } else {
                itemEntity.m_32064_();
            }
        }
        if ((entity = itemEntity.m_19749_()) instanceof Player) {
            Player player;
            this.barteringTarget = player = (Player)entity;
        }
    }

    private boolean canBarterWith(ItemStack stack) {
        return stack.m_150930_(Items.f_42616_) && this.m_21205_().m_41619_() && this.isOpen() && !this.isBartering();
    }

    public boolean m_7243_(ItemStack stack) {
        return this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_) && this.canBarterWith(stack);
    }

    @NotNull
    protected Vec3i m_213552_() {
        return ITEM_PICKUP_REACH;
    }

    public boolean isWakingUp() {
        int ticks = this.getDayStartTicks();
        return ticks > 0 && ticks < 62;
    }

    private boolean finishedWakeUp() {
        return this.getDayStartTicks() == 62;
    }

    private int getRandomChangeInterval() {
        return 800 + this.m_217043_().m_188503_(800);
    }

    public void barter() {
        if (this.isBartering()) {
            return;
        }
        this.m_9236_().m_7605_((Entity)this, (byte)9);
        this.changeStateTicks = this.getRandomChangeInterval();
        this.barteringTicks = 78;
    }

    @Override
    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!this.m_9236_().m_5776_() && this.canBarterWith(stack)) {
            this.barteringTarget = player;
            this.m_21008_(InteractionHand.MAIN_HAND, stack.m_41777_());
            stack.m_41774_(1);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(player, hand);
    }

    private List<ItemStack> getBarterResponseItems() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            LootTable lootTable = level2.m_7654_().m_278653_().m_278676_(BARTERING_LOOT);
            return lootTable.m_287195_(new LootParams.Builder(level2).m_287286_(LootContextParams.f_81455_, (Object)this).m_287235_(LootContextParamSets.f_81417_));
        }
        return List.of();
    }

    private void throwItems(List<ItemStack> stacks) {
        if (this.barteringTarget != null) {
            this.throwItemsTowardPlayer(this.barteringTarget, stacks);
        } else {
            this.throwItemsTowardRandomPos(stacks);
        }
    }

    private void throwItemsTowardRandomPos(List<ItemStack> stacks) {
        this.throwItemsTowardPos(stacks, this.getRandomNearbyPos());
    }

    private void throwItemsTowardPlayer(Player player, List<ItemStack> stacks) {
        this.throwItemsTowardPos(stacks, player.m_20182_());
    }

    private void throwItemsTowardPos(List<ItemStack> stacks, Vec3 pos) {
        for (ItemStack stack : stacks) {
            BehaviorUtils.m_22613_((LivingEntity)this, (ItemStack)stack, (Vec3)pos.m_82520_(0.0, 1.0, 0.0));
        }
    }

    private Vec3 getRandomNearbyPos() {
        Vec3 vec3 = LandRandomPos.m_148488_((PathfinderMob)this, (int)4, (int)2);
        return vec3 == null ? this.m_20182_() : vec3;
    }

    private class BarrelGolemPanicGoal
    extends PanicGoal {
        public BarrelGolemPanicGoal(double speedModifier) {
            super((PathfinderMob)BarrelGolem.this, speedModifier);
        }

        public boolean m_8036_() {
            return BarrelGolem.this.isOpen() && super.m_8036_();
        }

        public void m_8041_() {
            super.m_8041_();
            BarrelGolem.this.setOpen(false, true);
        }
    }

    private class BarrelGolemFindNearestEmeraldGoal
    extends Goal {
        private ItemEntity nearest;

        private BarrelGolemFindNearestEmeraldGoal() {
        }

        public boolean m_8036_() {
            ItemEntity nearest;
            if (BarrelGolem.this.isOpen() && !BarrelGolem.this.isBartering() && (nearest = (ItemEntity)BarrelGolem.this.m_9236_().m_6443_(ItemEntity.class, BarrelGolem.this.m_20191_().m_82400_(16.0), stack -> BarrelGolem.this.m_7243_(stack.m_32055_())).stream().findFirst().orElse(null)) != null) {
                this.nearest = nearest;
                return true;
            }
            return false;
        }

        public boolean m_8045_() {
            return BarrelGolem.this.isOpen() && !BarrelGolem.this.isBartering() && this.nearest != null && !this.nearest.m_213877_();
        }

        public void m_8037_() {
            BarrelGolem.this.f_21344_.m_5624_((Entity)this.nearest, 0.7);
            BarrelGolem.this.f_21365_.m_24960_((Entity)this.nearest, 30.0f, 30.0f);
        }
    }
}

