/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client.renderers.entities.golems;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.renderer.GeoRenderer;
import software.bernie.geckolib.renderer.layer.AutoGlowingGeoLayer;
import software.bernie.geckolib.renderer.layer.GeoRenderLayer;
import tech.alexnijjar.golemoverhaul.GolemOverhaul;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemModel;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.base.BaseGolemRenderer;
import tech.alexnijjar.golemoverhaul.common.entities.golems.KelpGolem;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class KelpGolemRenderer
extends BaseGolemRenderer<KelpGolem> {
    public static final ResourceLocation GLOW = GolemOverhaul.asResource("textures/entity/kelp/kelp_golem_glow.png");

    public KelpGolemRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, new BaseGolemModel<KelpGolem>(ModEntityTypes.KELP_GOLEM, true, 90));
        this.addRenderLayer((GeoRenderLayer)new AutoGlowingGeoLayer<KelpGolem>((GeoRenderer)this){

            protected RenderType getRenderType(KelpGolem animatable) {
                return RenderType.m_110488_((ResourceLocation)GLOW);
            }

            public void render(PoseStack poseStack, KelpGolem golem, BakedGeoModel bakedModel, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, float partialTick, int packedLight, int packedOverlay) {
                float percent = golem.m_21223_() / golem.m_21233_();
                renderType = this.getRenderType((KelpGolem)KelpGolemRenderer.this.animatable);
                this.getRenderer().reRender(bakedModel, poseStack, bufferSource, (GeoAnimatable)golem, renderType, bufferSource.m_6299_(renderType), partialTick, 0xF000F0, OverlayTexture.f_118083_, percent, percent, percent, percent);
            }
        });
    }

    public void renderRecursively(PoseStack poseStack, KelpGolem golem, GeoBone bone, RenderType renderType, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (("particle".equals(bone.getName()) || "particle2".equals(bone.getName())) && !golem.isCharged()) {
            return;
        }
        super.renderRecursively(poseStack, (Entity)golem, bone, renderType, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

