/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.golemoverhaul.client;

import com.teamresourceful.resourcefullib.common.network.Packet;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.architectury.registry.client.level.entity.EntityRendererRegistry;
import java.util.function.Supplier;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import software.bernie.geckolib.model.DefaultedEntityGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import tech.alexnijjar.golemoverhaul.client.forge.GolemOverhaulClientImpl;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.BarrelGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.CandleGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.CoalGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.HayGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.HoneyGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.KelpGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.NetheriteGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.SlimeGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.golems.TerracottaGolemRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.projectiles.CandleFlameProjectileRenderer;
import tech.alexnijjar.golemoverhaul.client.renderers.entities.projectiles.HoneyBlobProjectileRenderer;
import tech.alexnijjar.golemoverhaul.common.constants.ConstantComponents;
import tech.alexnijjar.golemoverhaul.common.entities.golems.NetheriteGolem;
import tech.alexnijjar.golemoverhaul.common.network.NetworkHandler;
import tech.alexnijjar.golemoverhaul.common.network.packets.ServerboundGolemSummonPacket;
import tech.alexnijjar.golemoverhaul.common.registry.ModBlocks;
import tech.alexnijjar.golemoverhaul.common.registry.ModEntityTypes;

public class GolemOverhaulClient {
    public static final KeyMapping KEY_NETHERITE_GOLEM_SUMMON = new KeyMapping(ConstantComponents.NETHERITE_GOLEM_SUMMON_KEY.getString(), 82, ConstantComponents.GOLEM_OVERHAUL_CATEGORY.getString());

    public static void init() {
        GolemOverhaulClient.registerKeyMappings();
        GolemOverhaulClient.registerEntityRenderers();
        GolemOverhaulClient.registerBlockRenderTypes();
    }

    private static void registerKeyMappings() {
        KeyMappingRegistry.register((KeyMapping)KEY_NETHERITE_GOLEM_SUMMON);
        ClientTickEvent.CLIENT_PRE.register(minecraft -> {
            if (KEY_NETHERITE_GOLEM_SUMMON.m_90859_()) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                if (player == null) {
                    return;
                }
                if (player.m_20202_() instanceof NetheriteGolem) {
                    NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundGolemSummonPacket());
                }
            }
        });
    }

    private static void registerEntityRenderers() {
        EntityRendererRegistry.register(ModEntityTypes.BARREL_GOLEM, BarrelGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.CANDLE_GOLEM, CandleGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.COAL_GOLEM, CoalGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.HAY_GOLEM, HayGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.HONEY_GOLEM, HoneyGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.KELP_GOLEM, KelpGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.NETHERITE_GOLEM, NetheriteGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.SLIME_GOLEM, SlimeGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.TERRACOTTA_GOLEM, TerracottaGolemRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.CANDLE_FLAME, CandleFlameProjectileRenderer::new);
        EntityRendererRegistry.register(ModEntityTypes.MUD_BALL, context -> new GeoEntityRenderer(context, (GeoModel)new DefaultedEntityGeoModel(BuiltInRegistries.f_256780_.m_7981_((Object)((EntityType)ModEntityTypes.MUD_BALL.get())))));
        EntityRendererRegistry.register(ModEntityTypes.HONEY_BLOB, HoneyBlobProjectileRenderer::new);
    }

    private static void registerBlockRenderTypes() {
        GolemOverhaulClient.registerBlockRenderType(ModBlocks.CANDLE_GOLEM_BLOCK, RenderType.m_110463_());
        GolemOverhaulClient.registerBlockRenderType(ModBlocks.CLAY_GOLEM_STATUE, RenderType.m_110463_());
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerBlockRenderType(Supplier<Block> block, RenderType type) {
        void var1_1;
        GolemOverhaulClientImpl.registerBlockRenderType(block, (RenderType)var1_1);
    }
}

