/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.core.manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.core.IManager;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.User;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.slf4j.Logger;

public class SplashManager
implements IManager {
    private static final Logger LOGGER = Debug.getLogger(SplashManager.class);
    private static final ResourceLocation LOCATION = ResourceLocations.of("splashes.txt");
    private static final Random RANDOM = new Random();
    private User user;
    private List<String> splashes;

    @Override
    public void onMinecraftInit(Minecraft minecraft) {
        this.user = minecraft.m_91094_();
        this.readSplashes(minecraft.m_91098_());
    }

    private void readSplashes(ResourceManager resourceManager) {
        try {
            Optional resource = resourceManager.m_213713_(LOCATION);
            if (resource.isPresent()) {
                BufferedReader reader = new BufferedReader(((Resource)resource.get()).m_215508_());
                this.splashes = reader.lines().toList();
            } else {
                LOGGER.error("Could not start reading, because it does not exist");
            }
        }
        catch (IOException e) {
            LOGGER.error("Could not access splash file: {}", (Object)e.getMessage());
        }
    }

    public String getSplash() {
        if (!this.splashes.isEmpty()) {
            String splash = this.splashes.get(RANDOM.nextInt(this.splashes.size()));
            if (splash.contains("{user.name}")) {
                splash = splash.replace("{user.name}", this.user.m_92546_());
            }
            return splash;
        }
        LOGGER.error("Could not get splash, it is empty");
        return "";
    }
}

