/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.core.manager;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.bivrik.fancytoasts.client.config.JsonHelper;
import net.bivrik.fancytoasts.client.config.data.ToastConfigData;
import net.bivrik.fancytoasts.client.registry.TextureRegistry;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.client.toast.FancyAdvancementToast;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.core.IManager;
import net.bivrik.fancytoasts.core.Managers;
import net.bivrik.fancytoasts.core.event.ToastConfigDataEvent;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.bivrik.fancytoasts.utility.file.FileHelper;
import net.bivrik.fancytoasts.utility.file.FileType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class CustomTextureManager
implements IManager {
    private static final Logger LOGGER = Debug.getLogger(CustomTextureManager.class);
    private static final File TEXTURES_DIR = new File("./config/fancytoasts/textures/");
    private static final FileFilter TEXTURE_FILES_FILTER = file -> {
        String name = file.getName();
        return name.endsWith(FileType.PNG.get()) || name.endsWith(FileType.JSON.get());
    };
    private final Map<ResourceLocation, DisplayData> customTextures = new HashMap<ResourceLocation, DisplayData>();
    private final List<ResourceLocation> registeredInMinecraft = new ArrayList<ResourceLocation>();
    private final Map<ResourceLocation, List<FancyAdvancementToast>> beingUsed = new HashMap<ResourceLocation, List<FancyAdvancementToast>>();
    private TextureManager textureManager;
    private ToastConfigData toastConfigData;

    @Override
    public void onMinecraftInit(Minecraft minecraft) {
        this.textureManager = minecraft.m_91097_();
        this.toastConfigData = Managers.getConfigManager().getToastConfigData();
        Managers.getEventManager().subscribeToEvent(ToastConfigDataEvent.class, this::onToastConfigDataChanged);
        this.load();
        this.registerInMainRegistry();
        ResourceLocation textureId = this.toastConfigData.getTextureId();
        if (textureId.m_135815_().contains("config")) {
            this.registerInMinecraft(textureId);
        }
    }

    private void onToastConfigDataChanged(ToastConfigDataEvent event) {
        this.toastConfigData = event.toastConfigData();
    }

    public void addBeingUsed(ResourceLocation id, FancyAdvancementToast toast) {
        if (!id.m_135815_().contains("config")) {
            return;
        }
        this.beingUsed.computeIfAbsent(id, list -> new ArrayList()).add(toast);
        LOGGER.info("Added to: {}, toast: {}; total size: {}", new Object[]{id, toast, this.beingUsed.get(id).size()});
    }

    public void removeBeingUsed(FancyAdvancementToast toast) {
        List<FancyAdvancementToast> toasts;
        ResourceLocation id = null;
        for (Map.Entry<ResourceLocation, List<FancyAdvancementToast>> entry : this.beingUsed.entrySet()) {
            if (!entry.getValue().contains(toast)) continue;
            id = entry.getKey();
            break;
        }
        if ((toasts = this.beingUsed.get(id)) != null) {
            toasts.remove(toast);
            LOGGER.info("Removed from: {}, toast: {}; total size: {}", new Object[]{id, toast, toasts.size()});
            if (toasts.isEmpty()) {
                this.beingUsed.remove(id);
                LOGGER.warn("Removed texture from cash: {}", (Object)id);
                ResourceLocation currentId = this.toastConfigData.getTextureId();
                if (currentId != id) {
                    this.releaseTextureFromMinecraft(id);
                }
            }
        }
    }

    public void registerInMinecraft(ResourceLocation id) {
        if (this.isRegisteredMinecraft(id)) {
            return;
        }
        if (!TextureRegistry.isRegistered(id)) {
            LOGGER.error("Could not register in Minecraft, because it does not exist in Texture Registry: {}", (Object)id);
            return;
        }
        try {
            NativeImage image = NativeImage.m_271751_((byte[])Files.readAllBytes(this.getFileFromId(id).toPath()));
            String dynamicTextureName = id.m_214298_().replace(FileType.PNG.get(), "").replace("/", "_").replace(".", "-");
            DynamicTexture dynamicTexture = new DynamicTexture(image);
            this.textureManager.m_118495_(id, (AbstractTexture)dynamicTexture);
            this.registeredInMinecraft.add(id);
            image.close();
            LOGGER.info("Registered in Minecraft: {}; {}", (Object)id, (Object)dynamicTextureName);
        }
        catch (IOException e) {
            throw new RuntimeException("An error occurred while registering custom texture in Minecraft: ", e);
        }
    }

    public void releaseTextureFromMinecraft(ResourceLocation id) {
        if (!this.registeredInMinecraft.contains(id)) {
            return;
        }
        this.textureManager.m_118513_(id);
        this.registeredInMinecraft.remove(id);
        LOGGER.info("Released from Minecraft: {}", (Object)id);
    }

    public void releaseUnusedTexturesFromMinecraft() {
        new ArrayList<ResourceLocation>(this.registeredInMinecraft).forEach(id -> {
            if (!this.beingUsed.containsKey(id)) {
                this.releaseTextureFromMinecraft((ResourceLocation)id);
            }
        });
    }

    public boolean isRegisteredMinecraft(ResourceLocation id) {
        return this.registeredInMinecraft.contains(id);
    }

    public void clear() {
        ResourceLocation currentId = this.toastConfigData.getTextureId();
        if (currentId.m_135815_().contains("config")) {
            this.registeredInMinecraft.forEach(id -> {
                if (currentId != id) {
                    this.textureManager.m_118513_(id);
                }
            });
        } else {
            this.registeredInMinecraft.forEach(id -> this.textureManager.m_118513_(id));
        }
        this.beingUsed.clear();
        this.registeredInMinecraft.clear();
    }

    public void reload() {
        this.load();
        this.cleanUpFromMainRegistry();
        this.registerInMainRegistry();
    }

    public void load() {
        if (FileHelper.tryCreateDir(TEXTURES_DIR)) {
            return;
        }
        File[] files = TEXTURES_DIR.listFiles(TEXTURE_FILES_FILTER);
        if (files == null) {
            LOGGER.info("No custom textures");
            return;
        }
        int initialCap = Math.max(0, files.length / 2 - 1);
        ArrayList<File> textureFiles = new ArrayList<File>(initialCap);
        ArrayList<File> jsonFiles = new ArrayList<File>(initialCap);
        for (File file : files) {
            String fileName = file.getName();
            if (fileName.endsWith(FileType.PNG.get())) {
                textureFiles.add(file);
                continue;
            }
            if (!fileName.endsWith(FileType.JSON.get())) continue;
            jsonFiles.add(file);
        }
        Map<String, File> texturesMap = textureFiles.stream().collect(Collectors.toMap(FileHelper::getRawName, textureFile -> textureFile));
        this.register(texturesMap, jsonFiles);
    }

    private void register(Map<String, File> texturesMap, List<File> jsonFiles) {
        this.customTextures.clear();
        for (File jsonFile : jsonFiles) {
            File textureFile = texturesMap.get(FileHelper.getRawName(jsonFile));
            if (textureFile == null) continue;
            Optional<DisplayData.DTO> optionalDataDTO = JsonHelper.tryToRead(jsonFile, DisplayData.DTO.class);
            if (optionalDataDTO.isPresent()) {
                DisplayData data = new DisplayData(optionalDataDTO.get());
                ResourceLocation id = this.getIdFromFile(textureFile);
                this.customTextures.put(id, data);
                LOGGER.info("Added: {}", (Object)id);
                continue;
            }
            LOGGER.warn("Json data is outdated or corrupted! File: {}", (Object)jsonFile.getAbsolutePath());
        }
    }

    private void cleanUpFromMainRegistry() {
        TextureRegistry.getCustomIds().forEach(id -> {
            if (!this.customTextures.containsKey(id)) {
                TextureRegistry.unregister(id);
            }
        });
    }

    private void registerInMainRegistry() {
        this.customTextures.forEach((id, data) -> {
            if (!TextureRegistry.isRegistered(id)) {
                TextureRegistry.register(id, data);
            }
        });
    }

    private ResourceLocation getIdFromFile(File file) {
        String rawPath = file.getPath().replace("\\", "/");
        return ResourceLocations.of(rawPath.replaceFirst("./config/fancytoasts", "config"));
    }

    private File getFileFromId(ResourceLocation id) {
        String rawPath = id.m_135815_().replaceFirst("config", "./config/fancytoasts");
        return new File(rawPath.replace("/", "\\"));
    }
}

