/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.core.manager;

import java.util.HashMap;
import net.bivrik.fancytoasts.client.config.ConfigHandler;
import net.bivrik.fancytoasts.client.config.data.ConfigData;
import net.bivrik.fancytoasts.client.config.data.GeneralConfigData;
import net.bivrik.fancytoasts.client.config.data.ToastConfigData;
import net.bivrik.fancytoasts.client.config.data.ToastsFilteringData;
import net.bivrik.fancytoasts.core.IManager;

public class ConfigManager
implements IManager {
    private final HashMap<Class<? extends ConfigData>, ConfigData> configs = new HashMap();

    @Override
    public void onModInit() {
        this.loadConfig(ToastConfigData.class);
        this.loadConfig(GeneralConfigData.class);
        this.loadConfig(ToastsFilteringData.class);
    }

    private <T extends ConfigData> void loadConfig(Class<T> configDataClass) {
        this.configs.remove(configDataClass);
        this.configs.put((Class<? extends ConfigData>)configDataClass, (ConfigData)ConfigHandler.load(configDataClass));
    }

    public <T extends ConfigData> void updateConfig(T configData) {
        this.configs.replace(configData.getClass(), configData);
    }

    private <T extends ConfigData> T getConfig(Class<T> configDataClass) {
        ConfigData result = this.configs.get(configDataClass).copy();
        if (result == null) {
            throw new IllegalStateException("Trying to access unregistered config: " + configDataClass.getSimpleName());
        }
        return (T)result;
    }

    public GeneralConfigData getGeneralConfigData() {
        return this.getConfig(GeneralConfigData.class);
    }

    public ToastConfigData getToastConfigData() {
        return this.getConfig(ToastConfigData.class);
    }

    public ToastsFilteringData getToastsFilteringData() {
        return this.getConfig(ToastsFilteringData.class);
    }
}

