/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.toast;

import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.network.chat.Component;

public class DisplayData {
    private static final Component UNKNOWN_LABEL = Components.of("label.unknown");
    private final Component displayName;
    private final Component displayAuthor;
    private final Component displayDescription;

    public DisplayData(String name, String author, String description, boolean isTranslatableName) {
        this.displayName = name != null ? (isTranslatableName ? Component.m_237115_((String)name) : Component.m_237113_((String)DisplayData.getVisualAppealingString(name))) : UNKNOWN_LABEL;
        this.displayAuthor = author != null ? Component.m_237113_((String)DisplayData.getVisualAppealingString(author)) : UNKNOWN_LABEL;
        this.displayDescription = description != null ? Component.m_237115_((String)description) : UNKNOWN_LABEL;
    }

    public DisplayData(DTO dto) {
        this(dto.name, dto.author, dto.description, false);
    }

    public Component getDisplayName() {
        return this.displayName;
    }

    public Component getDisplayDescription() {
        return this.displayDescription;
    }

    public Component getAuthor() {
        return this.displayAuthor;
    }

    public static String getVisualAppealingString(String stringToConvert) {
        if (stringToConvert == null || stringToConvert.isEmpty()) {
            return "";
        }
        if (DisplayData.isVisualAppealing(stringToConvert)) {
            return stringToConvert;
        }
        String visualAppealingString = stringToConvert.replace('.', ' ').replace('_', ' ').trim();
        if (visualAppealingString.isBlank()) {
            return "";
        }
        String firstLetter = visualAppealingString.substring(0, 1).toUpperCase();
        String leftovers = visualAppealingString.substring(1);
        return firstLetter + leftovers;
    }

    private static boolean isVisualAppealing(String stringToCheck) {
        return !stringToCheck.contains(".") && Character.isUpperCase(stringToCheck.charAt(0)) && !stringToCheck.contains("_");
    }

    public String toString() {
        return String.format("DisplayData{name='%s', author='%s', description='%s'}", this.displayAuthor.getString(), this.displayAuthor.getString(), this.displayDescription.getString());
    }

    public record DTO(String name, String author, String description) {
    }
}

