/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.registry;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.core.Debug;
import net.minecraft.resources.ResourceLocation;
import org.slf4j.Logger;

public class TextureRegistry {
    private static final Logger LOGGER = Debug.getLogger(TextureRegistry.class);
    private static final Map<ResourceLocation, DisplayData> TEXTURES = new HashMap<ResourceLocation, DisplayData>();

    private static void addTexture(ResourceLocation id, DisplayData data) {
        TEXTURES.put(id, data);
    }

    public static boolean register(ResourceLocation id, DisplayData data) {
        if (TextureRegistry.isRegistered(id)) {
            LOGGER.warn("{} already exists! It has to be unique", (Object)id);
            return false;
        }
        TextureRegistry.addTexture(id, data);
        LOGGER.info("Registered: {}", (Object)id);
        return true;
    }

    public static boolean register(ResourceLocation id, String name, String author, String description) {
        return TextureRegistry.register(id, new DisplayData(name, author, description, true));
    }

    public static void unregister(ResourceLocation id) {
        TEXTURES.remove(id);
        LOGGER.info("Unregistered: {}", (Object)id);
    }

    public static boolean isRegistered(ResourceLocation id) {
        return TEXTURES.getOrDefault(id, null) != null;
    }

    public static DisplayData getData(ResourceLocation id) {
        DisplayData data = TEXTURES.getOrDefault(id, null);
        if (data == null) {
            LOGGER.error("{} is missing, using default", (Object)id);
            return TextureRegistry.getDefaultData();
        }
        return data;
    }

    public static DisplayData getDefaultData() {
        return new DisplayData("fancytoasts.gui.unknown", "fancytoasts.gui.unknown", "fancytoasts.gui.unknown", true);
    }

    public static Collection<ResourceLocation> getIds() {
        return TEXTURES.keySet();
    }

    public static List<ResourceLocation> getCustomIds() {
        return TEXTURES.keySet().stream().filter(id -> id.m_135815_().contains("config")).collect(Collectors.toList());
    }
}

