/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import net.bivrik.fancytoasts.client.gui.ResourceLocationFilter;
import net.bivrik.fancytoasts.client.gui.SettingType;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.platform.utility.Colors;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class ResourceLocationList
extends ObjectSelectionList<Entry> {
    private final Map<ResourceLocation, String> displayNames = new HashMap<ResourceLocation, String>();
    private ResourceLocation[] resourceLocations;
    private SettingType settingType;
    private Consumer<ResourceLocation> selectResponder;
    private Consumer<ResourceLocation> focusResponder;
    private ResourceLocationFilter filter = ResourceLocationFilter.A_Z;
    private String search = "";

    public ResourceLocationList(Minecraft minecraft, int width, int height, int x, int y, int itemHeight, SettingType settingType) {
        super(minecraft, width, height, y, y + height, itemHeight);
        this.f_93393_ = x;
        this.f_93392_ = x + width;
        this.m_93471_(true);
        this.setResourceLocations(settingType);
    }

    public int m_5759_() {
        return this.f_93388_ - 6 - 16;
    }

    public int m_5747_() {
        return this.f_93393_ + this.f_93388_ / 2 - this.m_5759_() / 2 - 3;
    }

    protected int m_5756_() {
        return this.f_93392_ - 8;
    }

    public void setResourceLocations(SettingType settingType) {
        this.settingType = settingType;
        this.resourceLocations = this.settingType.getKeySet();
        this.displayNames.clear();
        for (ResourceLocation location : this.resourceLocations) {
            this.displayNames.computeIfAbsent(location, location1 -> this.settingType.getDisplayData((ResourceLocation)location1).getDisplayName().getString().toLowerCase(Locale.ROOT));
        }
        this.sortAZ();
        this.refillList();
    }

    private void refillList() {
        this.clearList();
        if (this.search.isEmpty()) {
            for (ResourceLocation location : this.resourceLocations) {
                this.m_7085_((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getDisplayName()));
            }
        } else {
            for (ResourceLocation location : this.resourceLocations) {
                if (!this.displayNames.get(location).contains(this.search)) continue;
                this.m_7085_((AbstractSelectionList.Entry)new ResourceLocationListEntry(this, location, this.settingType.getDisplayData(location).getDisplayName()));
            }
        }
    }

    private void clearList() {
        this.m_93516_();
        this.m_93410_(0.0);
    }

    public void setSearch(String search) {
        String lowercaseSearch;
        if (search == null) {
            search = "";
        }
        if (this.search.equals(lowercaseSearch = search.toLowerCase(Locale.ROOT))) {
            return;
        }
        this.search = lowercaseSearch;
        this.refillList();
    }

    public void setFilter(ResourceLocationFilter filter) {
        if (this.filter == filter || filter == null) {
            return;
        }
        this.filter = filter;
        this.onFilterUpdate();
    }

    private void onFilterUpdate() {
        switch (this.filter) {
            case A_Z: {
                this.sortAZ();
                break;
            }
            case Z_A: {
                this.sortAZ(Comparator.reverseOrder());
                break;
            }
            case BUILT_IN: {
                this.typeSort(true);
                break;
            }
            case CUSTOM: {
                this.typeSort(false);
            }
        }
        this.refillList();
    }

    private void sortAZ(Comparator<String> comparator) {
        Arrays.sort(this.resourceLocations, (loc1, loc2) -> comparator.compare(this.displayNames.get(loc1), this.displayNames.get(loc2)));
    }

    private void sortAZ() {
        this.sortAZ(Comparator.naturalOrder());
    }

    private void typeSort(boolean isBuiltInFilterType) {
        this.sortAZ();
        ArrayList<Object> builtInLocations = new ArrayList<Object>(this.resourceLocations.length * 2 / 3);
        ArrayList<ResourceLocation> configLocations = new ArrayList<ResourceLocation>();
        for (ResourceLocation location : this.resourceLocations) {
            String namespace = location.m_135827_();
            boolean isBuiltIn = namespace.equals("fancytoasts") || namespace.equals("minecraft");
            boolean isConfig = location.m_135815_().contains("config") || !isBuiltIn;
            if (isBuiltInFilterType == !isConfig) {
                builtInLocations.add(location);
                continue;
            }
            configLocations.add(location);
        }
        builtInLocations.addAll(configLocations);
        this.resourceLocations = builtInLocations.toArray(new ResourceLocation[0]);
    }

    public ResourceLocationList setSelectResponder(Consumer<ResourceLocation> selectResponder) {
        this.selectResponder = selectResponder;
        return this;
    }

    public ResourceLocationList setFocusResponder(Consumer<ResourceLocation> focusResponder) {
        this.focusResponder = focusResponder;
        return this;
    }

    private static final class ResourceLocationListEntry
    extends Entry {
        private final ResourceLocationList parentList;
        private final ResourceLocation id;
        private final boolean isConfig;
        private final Font font;
        private final SoundManager soundManager;
        private List<FormattedCharSequence> nameLines = new ArrayList<FormattedCharSequence>();
        private long lastClickTime;

        public ResourceLocationListEntry(ResourceLocationList parentList, ResourceLocation id, Component name) {
            this.parentList = parentList;
            Minecraft minecraft = this.parentList.f_93386_;
            this.soundManager = minecraft.m_91106_();
            this.font = minecraft.f_91062_;
            this.id = id;
            this.isConfig = this.id.m_135815_().contains("config");
            if (name != null) {
                this.nameLines = this.font.m_92923_((FormattedText)name, this.parentList.m_5759_() - 8 - 2);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (Util.m_137550_() - this.lastClickTime >= 250L) {
                this.lastClickTime = Util.m_137550_();
                this.focus();
            } else {
                this.select();
            }
            return super.m_6375_(mouseX, mouseY, button);
        }

        public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
            if (CommonInputs.m_278691_((int)keyCode)) {
                this.select();
            }
            return super.m_7933_(keyCode, scanCode, modifiers);
        }

        private void focus() {
            this.parentList.m_7522_((GuiEventListener)this);
            if (this.parentList.focusResponder != null) {
                this.parentList.focusResponder.accept(this.id);
            } else {
                Debug.error("There is no select responder for Resource Location List. Could not select location: " + this.id);
            }
        }

        private void select() {
            if (this.parentList.selectResponder != null) {
                this.parentList.selectResponder.accept(this.id);
                this.soundManager.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            } else {
                Debug.error("There is no accept responder for Resource Location List. Could not accept location: " + this.id);
            }
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            x += 3;
            int mainColor = -1;
            int secondColor = -6250336;
            if (this.m_93696_()) {
                mainColor = -256;
                secondColor = -377606;
            } else if (isHovering) {
                GuiContext context = new GuiContext(guiGraphics);
                context.fill(x, y - 2, width, height + 4, Colors.alpha(16, -1));
                context.fill(x + 1, y - 1, width - 2, height + 2, Colors.alpha(64, 0));
            }
            int nameX = x + 3;
            int nameY = y + 3;
            FormattedCharSequence nameFirstLine = this.nameLines.get(0);
            if (this.nameLines.size() == 1) {
                guiGraphics.m_280648_(this.font, nameFirstLine, nameX, nameY, mainColor);
            } else {
                guiGraphics.m_280648_(this.font, this.nameLines.get(1), nameX, nameY + 3, secondColor);
                guiGraphics.m_280648_(this.font, nameFirstLine, nameX, nameY - 3, mainColor);
            }
            if (this.isConfig) {
                guiGraphics.m_280430_(this.font, (Component)Component.m_237113_((String)"c"), x + width - 10, nameY, -6250336);
            }
        }
    }

    protected static abstract class Entry
    extends ObjectSelectionList.Entry<Entry> {
        protected Entry() {
        }

        @NotNull
        public Component m_142172_() {
            return Component.m_237119_();
        }
    }
}

