/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.client.toast.DisplayData;
import net.bivrik.fancytoasts.core.Debug;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.bivrik.fancytoasts.platform.utility.GuiContext;
import net.bivrik.fancytoasts.platform.utility.ResourceLocations;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.NotNull;

public class InformationList
extends AbstractSelectionList<Entry> {
    private static final Component CUSTOM_LABEL = Components.of("label.custom");
    private static final Component AUTHOR_LABEL = Components.of("label.author");
    private static final Component DESCRIPTION_LABEL = Components.of("label.description");
    private final List<InformationListEntry> lines = new ArrayList<InformationListEntry>(7);
    private ResourceLocation location;

    public InformationList(Minecraft minecraft, int width, int height, int x, int y, DisplayData displayData, boolean isConfig) {
        super(minecraft, width, height, y, y + height, 10);
        this.f_93393_ = x;
        this.f_93392_ = x + width;
        this.m_93471_(false);
        this.update(displayData, isConfig, true);
    }

    public void update(DisplayData displayData, boolean isConfig, boolean isSelected) {
        if (displayData == null) {
            Debug.error("No Display Data to show in Information List");
            return;
        }
        this.location = isSelected ? ResourceLocations.of("textures/gui/icons/success.png") : ResourceLocations.of("textures/gui/icons/looking.png");
        this.clear();
        this.addLine(displayData.getDisplayName(), -256);
        if (isConfig) {
            this.addLine(CUSTOM_LABEL, -2338993);
        }
        this.addSpace();
        this.addLine(AUTHOR_LABEL, -1);
        this.addLine(displayData.getAuthor(), -6250336);
        this.addSpace();
        this.addLine(DESCRIPTION_LABEL, -1);
        this.addLine(displayData.getDisplayDescription(), -6250336);
        this.acceptLines();
    }

    private void clear() {
        this.m_93516_();
        this.m_93410_(0.0);
        this.lines.clear();
    }

    private void addLine(Component content, int color) {
        Font font = this.f_93386_.f_91062_;
        List textLines = font.m_92923_((FormattedText)content, this.m_5759_());
        for (FormattedCharSequence textLine : textLines) {
            this.lines.add(new InformationListEntry(font, textLine, color));
        }
    }

    private void addSpace() {
        this.lines.add(new InformationListEntry(this.f_93386_.f_91062_, FormattedCharSequence.f_13691_, 0));
    }

    private void acceptLines() {
        for (InformationListEntry line : this.lines) {
            this.m_7085_(line);
        }
    }

    public void m_88315_(@NotNull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        GuiContext context = new GuiContext(guiGraphics);
        context.drawSprite(this.location, this.f_93392_ - 8 - 3, this.f_93390_ + 3, 8, 8);
    }

    public int m_5759_() {
        return this.f_93388_ - 16 - 8;
    }

    public int m_5747_() {
        return this.f_93393_ + 8;
    }

    protected int m_5756_() {
        return this.f_93392_ + this.f_93388_ - 8;
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    private static final class InformationListEntry
    extends Entry {
        private final Font font;
        private final FormattedCharSequence content;
        private final int color;

        public InformationListEntry(Font font, FormattedCharSequence content, int color) {
            this.font = font;
            this.content = content;
            this.color = color;
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.m_280648_(this.font, this.content, x, y + 3, this.color);
        }
    }

    protected static abstract class Entry
    extends AbstractSelectionList.Entry<Entry> {
        protected Entry() {
        }
    }
}

