/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.bivrik.fancytoasts.core.manager.CreditsManager;
import net.bivrik.fancytoasts.platform.utility.Components;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class CreditsList
extends AbstractSelectionList<Entry> {
    private final List<Entry> lines = new ArrayList<Entry>(10);
    private float autoScrollSpeed = 0.4f;

    public CreditsList(Minecraft minecraft, int width, int height, int x, int y, CreditsManager.CreditsData data) {
        super(minecraft, width, height, y, y + height, 18);
        this.f_93393_ = x;
        this.f_93392_ = x + width;
        this.m_93471_(false);
        this.m_93496_(false);
        this.m_93488_(false);
        this.updateList(data);
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280246_(0.25f, 0.25f, 0.25f, 1.0f);
        guiGraphics.m_280163_(Screen.f_279548_, this.f_93393_, this.f_93390_, (float)this.f_93392_, (float)(this.f_93391_ + (int)this.m_93517_()), this.f_93392_ - this.f_93393_, this.f_93391_ - this.f_93390_, 32, 32);
        guiGraphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    private void updateList(CreditsManager.CreditsData data) {
        for (int i = 0; i < this.f_93389_ / this.f_93387_ + 2; ++i) {
            this.addSpace();
        }
        for (String category : data.categories().keySet()) {
            this.addCategory(category);
            for (CreditsManager.CreditsData.User user : data.categories().get(category)) {
                this.addLine(user);
            }
            this.addSpace();
        }
        for (int i = 0; i < this.f_93389_ / this.f_93387_; ++i) {
            this.addSpace();
        }
        this.acceptLines();
    }

    private void acceptLines() {
        for (Entry line : this.lines) {
            this.m_7085_(line);
        }
    }

    private void addSpace() {
        this.lines.add(new SpaceEntry(this, ""));
    }

    private void addCategory(String category) {
        this.lines.add(new CategoryEntry(this, category));
    }

    private void addLine(CreditsManager.CreditsData.User user) {
        String content = user.name().compareTo("{user.name}") != 0 ? user.name() : this.f_93386_.m_91094_().m_92546_();
        this.lines.add(new UserEntry(this, content, user.annotation()));
    }

    public void scroll() {
        this.m_93410_(this.m_93517_() + (double)this.autoScrollSpeed);
        if (this.m_93517_() == (double)this.m_93518_()) {
            this.m_93410_(0.0);
        }
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 1.2f;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 32) {
            this.autoScrollSpeed = 0.4f;
        }
        return super.m_7920_(keyCode, scanCode, modifiers);
    }

    protected int m_5756_() {
        return this.f_93388_ * 2;
    }

    public void m_142291_(@NotNull NarrationElementOutput narrationElementOutput) {
    }

    protected static abstract class Entry
    extends AbstractSelectionList.Entry<Entry> {
        protected final CreditsList parentList;
        protected final String content;
        protected final Font font;

        public Entry(CreditsList parentList, String content) {
            this.parentList = parentList;
            this.content = content;
            this.font = ((CreditsList)this.parentList).f_93386_.f_91062_;
        }

        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
        }
    }

    private static class SpaceEntry
    extends Entry {
        public SpaceEntry(CreditsList parentList, String content) {
            super(parentList, content);
        }
    }

    private static class CategoryEntry
    extends Entry {
        private final Component displayName;
        private final int xCenter;

        public CategoryEntry(CreditsList parentList, String content) {
            super(parentList, content);
            this.displayName = Components.of("label." + this.content);
            this.xCenter = parentList.f_93388_ / 2;
        }

        @Override
        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.m_280653_(this.font, this.displayName, this.xCenter, y, -256);
        }
    }

    private static class UserEntry
    extends Entry {
        private final String annotation;
        private final boolean isValidAnnotation;

        public UserEntry(CreditsList parentList, String content, String annotation) {
            super(parentList, content);
            this.annotation = annotation;
            this.isValidAnnotation = this.annotation != null && !this.annotation.isEmpty();
        }

        @Override
        public void m_6311_(@NotNull GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean isHovering, float partialTick) {
            guiGraphics.m_280488_(this.font, this.content, x, y, -1);
            if (this.isValidAnnotation) {
                guiGraphics.m_280488_(this.font, this.annotation, x + this.font.m_92895_(this.content) + 8, y, -6250336);
            }
        }
    }
}

