/*
 * Decompiled with CFR 0.152.
 */
package net.bivrik.fancytoasts.client.config.data;

public abstract class ConfigData {
    private final transient String path;
    private int version;

    protected ConfigData(String path) {
        this.path = path;
        this.version = 0;
    }

    protected <T extends ConfigData> T withLatestVersion() {
        this.version = this.getLatestVersion();
        ConfigData result = this;
        return (T)result;
    }

    public int getVersion() {
        return this.version;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isOutdated() {
        return this.version != this.getLatestVersion();
    }

    public boolean isValid() {
        return true;
    }

    public abstract int getLatestVersion();

    public abstract ConfigData copy();

    public String toString() {
        return this.getClass().getSimpleName() + String.format("{path='%s', version='%s'}", this.path, this.version);
    }
}

