/*
 * Decompiled with CFR 0.152.
 */
package malfu.bc_particle.network;

import java.util.List;
import java.util.function.Supplier;
import malfu.bc_particle.BetterCombatParticleMods;
import malfu.bc_particle.config.ParticleSettings;
import malfu.bc_particle.config.ParticleSettingsLoader;
import malfu.bc_particle.network.ClientNetworkHandler;
import malfu.bc_particle.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class CustomParticlePayload {
    private final String animationName;
    private final double x;
    private final double y;
    private final double z;
    private final double xStab;
    private final double yStab;
    private final double zStab;
    private final float pitch;
    private final float yaw;
    private final float weaponRange;
    private final boolean isOffhand;
    private final boolean light;
    private final String colorHex;
    private final String colorHexSec;

    public CustomParticlePayload(String animationName, double x, double y, double z, double xStab, double yStab, double zStab, float pitch, float yaw, float weaponRange, boolean isOffhand, boolean light, String colorHex, String colorHexSec) {
        this.animationName = animationName;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xStab = xStab;
        this.yStab = yStab;
        this.zStab = zStab;
        this.pitch = pitch;
        this.yaw = yaw;
        this.weaponRange = weaponRange;
        this.isOffhand = isOffhand;
        this.light = light;
        this.colorHex = colorHex;
        this.colorHexSec = colorHexSec;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130070_(this.animationName);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.xStab);
        buf.writeDouble(this.yStab);
        buf.writeDouble(this.zStab);
        buf.writeFloat(this.pitch);
        buf.writeFloat(this.yaw);
        buf.writeFloat(this.weaponRange);
        buf.writeBoolean(this.isOffhand);
        buf.writeBoolean(this.light);
        buf.m_130070_(this.colorHex);
        buf.m_130070_(this.colorHexSec);
    }

    public static CustomParticlePayload decode(FriendlyByteBuf buf) {
        return new CustomParticlePayload(buf.m_130277_(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readDouble(), buf.readFloat(), buf.readFloat(), buf.readFloat(), buf.readBoolean(), buf.readBoolean(), buf.m_130277_(), buf.m_130277_());
    }

    public void handle(Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            if (context.getDirection().getReceptionSide().isServer()) {
                ServerPlayer sender = context.getSender();
                if (sender == null) {
                    return;
                }
                for (ServerPlayer otherPlayer : sender.m_284548_().m_6907_()) {
                    if (otherPlayer == sender) continue;
                    NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> otherPlayer), (Object)new CustomParticlePayload(this.animationName, this.x, this.y, this.z, this.xStab, this.yStab, this.zStab, this.pitch, this.yaw, this.weaponRange, this.isOffhand, this.light, this.colorHex, this.colorHexSec));
                }
            } else {
                List<ParticleSettings> settings = ParticleSettingsLoader.INSTANCE.getSettings(this.animationName);
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91073_ != null && BetterCombatParticleMods.config.showOtherPlayerParticle) {
                    ClientNetworkHandler.spawnParticleFromNetwork(mc.f_91073_, this.x, this.y, this.z, this.xStab, this.yStab, this.zStab, this.pitch, this.yaw, this.weaponRange, this.isOffhand, settings, this.light, this.colorHex, this.colorHexSec);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

