/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.level.feature;

import com.idark.valoria.registries.level.configurations.GradientOreConfiguration;
import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;

public class GradientOreFeature
extends Feature<GradientOreConfiguration> {
    public GradientOreFeature(Codec<GradientOreConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<GradientOreConfiguration> context) {
        GradientOreConfiguration config = (GradientOreConfiguration)context.m_159778_();
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        int radius = config.radius;
        List<BlockState> gradientBlocks = config.gradientBlocks;
        int segments = gradientBlocks.size() - 1;
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    BlockPos pos = origin.m_7918_(x, y, z);
                    double dist = Math.sqrt(x * x + y * y + z * z);
                    if (dist > (double)radius) continue;
                    int index = (int)Math.floor(dist / (double)radius * (double)segments);
                    BlockState chosenState = index >= segments ? gradientBlocks.get(segments) : (random.m_188500_() < 1.0 - dist / (double)radius * (double)segments - (double)index ? gradientBlocks.get(index) : gradientBlocks.get(index + 1));
                    double chance = 1.0 - 0.9 * dist / (double)radius;
                    if (!(random.m_188500_() < chance) || !this.canReplace(level, pos, config)) continue;
                    level.m_7731_(pos, chosenState, 2);
                }
            }
        }
        return true;
    }

    private boolean canReplace(WorldGenLevel level, BlockPos pos, GradientOreConfiguration config) {
        return level.m_8055_(pos).m_60713_(config.targetBlock.m_60734_());
    }
}

