/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.level;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.capability.INihilityLevel;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.DamageSourceRegistry;
import com.idark.valoria.registries.level.LevelGen;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.TickEvent;
import pro.komaru.tridot.client.render.gui.overlay.ClampedOverlayInstance;
import pro.komaru.tridot.util.Tmp;

public class NihilityMeter {
    public static float damagingLevel = 0.5f;
    public static float criticalLevel = 0.75f;
    public static final ClampedOverlayInstance instance = new ClampedOverlayInstance().setTexture(Valoria.loc("textures/gui/overlay/corruption.png"));

    public static void tick(TickEvent.PlayerTickEvent event, INihilityLevel nihilityLevel, Player player) {
        float max = nihilityLevel.getMaxAmount((LivingEntity)player, false);
        float amount = nihilityLevel.getAmount(false);
        if (player.m_9236_().m_46472_() == LevelGen.VALORIA_KEY) {
            NihilityMeter.valoriaTick(nihilityLevel, player);
        } else if (player.f_19797_ % 120 == 0 && amount > 0.0f) {
            nihilityLevel.decrease(event.player, Tmp.rnd.nextInt(1, 5));
        }
        if (NihilityMeter.isDamagingLevel(player, amount, max)) {
            boolean flag;
            float ratio = amount / max;
            boolean bl = flag = ratio >= damagingLevel;
            if (flag) {
                int segments = (int)((ratio - damagingLevel) / 0.1f);
                float damage = 1 + segments * 2;
                player.m_6469_(DamageSourceRegistry.voidHarm(player.m_9236_()), damage);
            }
            if (amount > max * criticalLevel && !player.m_21023_(MobEffects.f_19610_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 120, 0));
            }
        }
    }

    public static void clientTick(INihilityLevel nihilityLevel, Player player) {
    }

    private static boolean isDamagingLevel(Player player, float amountClient, float maxClient) {
        return player.f_19797_ % (amountClient < maxClient * criticalLevel ? 40 : 20) == 0;
    }

    private static void valoriaTick(INihilityLevel nihilityLevel, Player player) {
        if (player.f_19797_ % (int)(player.m_21133_((Attribute)AttributeReg.NIHILITY_RESILIENCE.get()) * 20.0) == 0) {
            double resistance = player.m_21133_((Attribute)AttributeReg.NIHILITY_RESISTANCE.get());
            double factor = Math.max(0.05, 1.0 - resistance * 0.05);
            nihilityLevel.modifyAmount((LivingEntity)player, (int)Math.ceil((double)Tmp.rnd.nextInt(1, 5) * factor));
        }
    }
}

