/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.ranged.bows;

import com.idark.valoria.Valoria;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.projectile.PhantomArrow;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.ValoriaUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ForgeEventFactory;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.types.ConfigurableBowItem;
import pro.komaru.tridot.util.struct.data.Seq;

public class PhantasmBow
extends ConfigurableBowItem
implements TooltipComponentItem {
    public int abilityUseDuration = 10;

    public PhantasmBow(double pBaseDamage, int pArrowBaseDamage, Item.Properties pProperties) {
        super(EntityTypeRegistry.PHANTOM_ARROW, pBaseDamage, pArrowBaseDamage, pProperties);
    }

    public ItemStack m_7968_() {
        return this.setBow(super.m_7968_());
    }

    public ItemStack setBow(ItemStack pStack) {
        pStack.m_41784_().m_128379_("isVisible", false);
        pStack.m_41784_().m_128379_("isPlayed", false);
        return pStack;
    }

    public boolean isPlayed(ItemStack pStack) {
        return pStack.m_41784_().m_128471_("isPlayed");
    }

    public boolean isVisible(ItemStack pStack) {
        return pStack.m_41784_().m_128471_("isVisible");
    }

    public void setPlayed(ItemStack pStack, boolean value) {
        pStack.m_41749_("isPlayed");
        pStack.m_41784_().m_128379_("isPlayed", value);
    }

    public void setVisible(ItemStack pStack, boolean value) {
        pStack.m_41749_("isVisible");
        pStack.m_41784_().m_128379_("isVisible", value);
    }

    public boolean m_142522_(ItemStack stack) {
        return stack.m_41768_() || this.isVisible(stack);
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        super.onStopUsing(stack, entity, count);
        this.setPlayed(stack, false);
        this.setVisible(stack, false);
    }

    public int m_142158_(ItemStack stack) {
        LocalPlayer plr;
        if (this.isVisible(stack) && (plr = Minecraft.m_91087_().f_91074_) != null) {
            int current = Minecraft.m_91087_().f_91074_.m_21212_();
            int used = this.m_8105_(stack) - current;
            float overcharge = Mth.m_14036_((float)((float)used - this.time), (float)0.0f, (float)this.abilityUseDuration);
            float progress = overcharge / (float)this.abilityUseDuration;
            return Math.round(13.0f * progress);
        }
        return super.m_142158_(stack);
    }

    public int m_142159_(ItemStack stack) {
        if (this.isVisible(stack)) {
            return Pal.crystalBlue.pack();
        }
        return super.m_142159_(stack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        super.m_5929_(pLevel, pLivingEntity, pStack, pRemainingUseDuration);
        int i = this.m_8105_(pStack) - pRemainingUseDuration;
        if (i < 0) {
            return;
        }
        ItemStack itemstack = pLivingEntity.m_6298_(pStack);
        if (!itemstack.m_150930_(Items.f_42412_)) {
            return;
        }
        if ((float)i >= this.time && !this.isPlayed(pStack)) {
            this.setVisible(pStack, true);
            if (this.isOvercharged(i, this.time)) {
                pLivingEntity.m_216990_((SoundEvent)SoundsRegistry.MAGIC_SHOOT.get());
                this.setPlayed(pStack, true);
            }
        }
    }

    public boolean isOvercharged(int progress, float time) {
        if ((float)progress >= time) {
            float overcharge = (float)progress - time;
            return overcharge > (float)this.abilityUseDuration;
        }
        return false;
    }

    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.phantasm_bow").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/phantom_rain.png"))});
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            boolean flag = player.m_150110_().f_35937_ || EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44952_, (ItemStack)pStack) > 0;
            ItemStack itemstack = player.m_6298_(pStack);
            int i = this.m_8105_(pStack) - pTimeLeft;
            if ((i = ForgeEventFactory.onArrowLoose((ItemStack)pStack, (Level)pLevel, (Player)player, (int)i, (!itemstack.m_41619_() || flag ? 1 : 0) != 0)) < 0) {
                return;
            }
            if (!itemstack.m_41619_() || flag) {
                float power;
                if (itemstack.m_41619_()) {
                    itemstack = new ItemStack((ItemLike)Items.f_42412_);
                }
                if (!((double)(power = PhantasmBow.getPowerForTime((int)i, (float)this.time)) < 0.1)) {
                    boolean infiniteArrows;
                    boolean bl = infiniteArrows = player.m_150110_().f_35937_ || itemstack.m_41720_() instanceof ArrowItem && ((ArrowItem)itemstack.m_41720_()).isInfinite(itemstack, pStack, player);
                    if (!pLevel.m_5776_()) {
                        int enchantmentPunch;
                        int enchantmentPower;
                        ArrowItem arrowitem = (ArrowItem)(itemstack.m_41720_() instanceof ArrowItem ? itemstack.m_41720_() : Items.f_42412_);
                        AbstractArrow abstractarrow = arrowitem == Items.f_42412_ && this.arrow.get() != EntityType.f_20548_ ? this.createArrow(pLevel, player) : arrowitem.m_6394_(pLevel, itemstack, (LivingEntity)player);
                        this.doPreSpawn(abstractarrow, player, itemstack, power, infiniteArrows);
                        if (this.isOvercharged(i, this.time) && abstractarrow instanceof PhantomArrow) {
                            PhantomArrow phantomArrow = (PhantomArrow)abstractarrow;
                            phantomArrow.burst = true;
                            phantomArrow.spread -= ValoriaUtils.enchantmentAccuracy(pStack);
                        }
                        if ((enchantmentPower = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44988_, (ItemStack)pStack)) > 0) {
                            abstractarrow.m_36781_(abstractarrow.m_36789_() + (double)enchantmentPower * 0.5 + 0.5);
                        }
                        if ((enchantmentPunch = EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44989_, (ItemStack)pStack)) > 0) {
                            abstractarrow.m_36735_(enchantmentPunch);
                        }
                        if (EnchantmentHelper.getTagEnchantmentLevel((Enchantment)Enchantments.f_44990_, (ItemStack)pStack) > 0) {
                            abstractarrow.m_20254_(100);
                        }
                        pStack.m_41622_(1, (LivingEntity)player, p_289501_ -> p_289501_.m_21190_(player.m_7655_()));
                        pLevel.m_7967_((Entity)abstractarrow);
                    }
                    pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11687_, SoundSource.PLAYERS, 1.0f, 1.0f / (pLevel.m_213780_().m_188501_() * 0.4f + 1.2f) + power * 0.5f);
                    if (!infiniteArrows && !player.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                        if (itemstack.m_41619_()) {
                            player.m_150109_().m_36057_(itemstack);
                        }
                    }
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        }
    }
}

