/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.elemental;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.Valoria;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.item.types.ScytheItem;
import com.idark.valoria.util.ValoriaUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.client.render.screenshake.PositionedScreenshakeInstance;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.common.registry.item.components.AbilityComponent;
import pro.komaru.tridot.common.registry.item.components.SeparatorComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.comps.phys.Pos3;
import pro.komaru.tridot.util.math.ArcRandom;
import pro.komaru.tridot.util.math.Interp;
import pro.komaru.tridot.util.struct.data.Seq;

public class InfernalScytheItem
extends ScytheItem {
    public ArcRandom arcRandom = Tmp.rnd;
    private final float attackDamage;
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public InfernalScytheItem(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builderIn) {
        super(tier, attackDamageIn, attackSpeedIn, builderIn);
        this.attackDamage = attackDamageIn + tier.m_6631_();
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)((Attribute)AttributeReg.INFERNAL_DAMAGE.get()), (Object)new AttributeModifier(Valoria.BASE_INFERNAL_DAMAGE_UUID, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.attackDamage - 2.0f), AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)attackSpeedIn, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @Override
    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot pEquipmentSlot) {
        return pEquipmentSlot == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(pEquipmentSlot);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, p_43296_ -> p_43296_.m_21166_(EquipmentSlot.MAINHAND));
        if (EnchantmentHelper.m_44914_((LivingEntity)pAttacker) > 0) {
            pAttacker.m_9236_().m_5594_(null, pTarget.m_20097_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, 1.0f);
        } else if (this.arcRandom.chance(0.07f)) {
            pTarget.m_20254_(4);
            pAttacker.m_9236_().m_5594_(null, pTarget.m_20097_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    public void performAttack(Level level, ItemStack stack, Player player) {
        ArrayList<LivingEntity> hitEntities = new ArrayList<LivingEntity>();
        Vector3d pos = new Vector3d(player.m_20185_(), player.m_20186_() + (double)player.m_20192_(), player.m_20189_());
        float damage = (float)player.m_21133_(Attributes.f_22281_) + EnchantmentHelper.m_44821_((LivingEntity)player);
        float radius = (float)player.m_21133_((Attribute)AttributeReg.ATTACK_RADIUS.get());
        ValoriaUtils.radiusHit(level, player, (ParticleOptions)ParticleTypes.f_123744_, hitEntities, pos, 0.0f, player.m_20155_().f_82471_, radius);
        this.applyCooldown(player, hitEntities.isEmpty() ? this.builder.minCooldownTime : this.builder.cooldownTime);
        for (LivingEntity entity : hitEntities) {
            if (!player.m_6779_(entity)) continue;
            entity.m_6469_(level.m_269111_().m_269075_(player), (damage + EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)entity.m_6336_())) * 1.35f);
            this.performEffects(entity, player);
            Utils.Entities.applyWithChance((LivingEntity)entity, this.builder.effects, (float)this.builder.chance, (ArcRandom)this.arcRandom);
            if (player.m_7500_()) continue;
            stack.m_41622_(hitEntities.size(), (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
        }
        ScreenshakeHandler.add((ScreenshakeInstance)new PositionedScreenshakeInstance(3, (Pos3)pro.komaru.tridot.util.phys.Vec3.from((Vec3)player.m_146892_()), 0.0f, 30.0f).intensity(0.5f).interp(Interp.circleOut));
    }

    @Override
    public void performEffects(LivingEntity targets, Player player) {
        targets.m_147240_((double)0.4f, player.m_20185_() - targets.m_20185_(), player.m_20189_() - targets.m_20189_());
        if (EnchantmentHelper.m_44914_((LivingEntity)player) > 0) {
            int i = EnchantmentHelper.m_44914_((LivingEntity)player);
            targets.m_20254_(i * 4);
            targets.m_9236_().m_5594_(null, targets.m_20097_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, 1.0f);
        } else if (this.arcRandom.chance(0.07f)) {
            targets.m_20254_(4);
            targets.m_9236_().m_5594_(null, targets.m_20097_(), SoundEvents.f_11874_, SoundSource.AMBIENT, 1.0f, 1.0f);
        }
    }

    @Override
    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        if (this.builder.attackUsages > 1) {
            return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.scythe").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/infernal_strike.png")), new TextComponent(Component.m_237110_((String)"tooltip.valoria.usage_count", (Object[])new Object[]{this.builder.attackUsages}).m_130940_(ChatFormatting.GRAY)), new TextComponent(Component.m_237115_((String)"tooltip.valoria.rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
        }
        return Seq.with((Object[])new TooltipComponent[]{new SeparatorComponent((Component)Component.m_237115_((String)"tooltip.valoria.abilities")), new AbilityComponent(Component.m_237115_((String)"tooltip.valoria.scythe").m_130940_(ChatFormatting.GRAY), Valoria.loc("textures/gui/tooltips/infernal_strike.png")), new TextComponent(Component.m_237115_((String)"tooltip.valoria.rmb").m_130938_(style -> style.m_131150_(Valoria.FONT)))});
    }

    @Override
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add(1, (Component)Component.m_237110_((String)"tooltip.valoria.infernal_scythe", (Object[])new Object[]{Component.m_237113_((String)String.format("%.1f%%", Float.valueOf(7.0f)))}).m_130940_(ChatFormatting.GRAY));
        Utils.Items.effectTooltip(this.builder.effects, tooltip, (float)1.0f, (float)this.builder.chance);
    }
}

