/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.ValoriaClient;
import com.idark.valoria.registries.item.types.builders.AbstractCurioBuilder;
import com.idark.valoria.registries.item.types.curio.AbstractTieredAccessory;
import com.idark.valoria.registries.item.types.curio.ICurioTexture;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraftforge.registries.ForgeRegistries;
import pro.komaru.tridot.common.registry.item.TooltipComponentItem;
import pro.komaru.tridot.common.registry.item.builders.AbstractArmorBuilder;
import pro.komaru.tridot.common.registry.item.components.EffectsListComponent;
import pro.komaru.tridot.common.registry.item.components.EmptyComponent;
import pro.komaru.tridot.common.registry.item.components.TextComponent;
import pro.komaru.tridot.util.struct.data.Seq;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CurioAccessoryItem
extends AbstractTieredAccessory
implements ICurioTexture,
TooltipComponentItem {
    public AbstractCurioBuilder<? extends CurioAccessoryItem, ?> builder;

    public CurioAccessoryItem(AbstractCurioBuilder<? extends CurioAccessoryItem, ?> builder) {
        super(builder.tier, builder.itemProperties);
        this.builder = builder;
    }

    @Override
    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        if (this.builder.equipSound != null) {
            return new ICurio.SoundInfo(this.builder.equipSound, this.builder.volume, this.builder.pitch);
        }
        return super.getEquipSound(slotContext, stack);
    }

    @Override
    public ResourceLocation getTexture(ItemStack stack, LivingEntity entity) {
        if (this.builder.texPath != null && this.builder.dependsOnStack) {
            return this.getTexture(this.builder.texPath, stack);
        }
        return this.builder.texPath;
    }

    @Override
    public void curioTick(SlotContext slotContext, ItemStack stack) {
        super.curioTick(slotContext, stack);
        Player player = (Player)slotContext.entity();
        if (player.m_9236_().m_5776_() && ValoriaClient.JEWELRY_BONUSES_KEY.m_90857_()) {
            this.applyEffects(player, stack);
        }
    }

    public void applyEffects(Player player, ItemStack stack) {
        if (!player.m_36335_().m_41519_(stack.m_41720_()) && !this.builder.effects.isEmpty()) {
            for (MobEffectInstance effectInstance : this.builder.effects) {
                player.m_7292_(new MobEffectInstance(effectInstance));
                player.m_36335_().m_41524_(stack.m_41720_(), effectInstance.m_19557_() + 300);
                CurioAccessoryItem.accessoryHurt(player, stack, this.tier);
            }
        }
    }

    private ResourceLocation getTexture(ResourceLocation texPath, ItemStack stack) {
        return new ResourceLocation(texPath.m_135827_(), texPath.m_135815_() + ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()).m_135815_() + ".png");
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(SlotContext slotContext, UUID uuid, ItemStack stack) {
        LinkedHashMultimap m = LinkedHashMultimap.create();
        this.builder.attributeMap.forEach((arg_0, arg_1) -> CurioAccessoryItem.lambda$getAttributeModifiers$0(uuid, (Multimap)m, arg_0, arg_1));
        this.builder.slotModifiers.forEach((arg_0, arg_1) -> CurioAccessoryItem.lambda$getAttributeModifiers$1((Multimap)m, uuid, arg_0, arg_1));
        return m;
    }

    public Seq<TooltipComponent> getTooltips(ItemStack pStack) {
        Seq seq = Seq.with();
        if (!this.builder.effects.isEmpty()) {
            seq.addAll((Object[])new TooltipComponent[]{new EffectsListComponent((List)this.builder.effects.list(), (Component)Component.m_237115_((String)"tooltip.tridot.applies").m_130940_(ChatFormatting.GRAY)), new EmptyComponent(6), new TextComponent(Component.m_237110_((String)"tooltip.valoria.jewelry_bonus", (Object[])new Object[]{ValoriaClient.JEWELRY_BONUSES_KEY.getKey().m_84875_()}).m_130940_(ChatFormatting.GREEN))});
        }
        return seq;
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$1(Multimap m, UUID uuid, String slot, AbstractArmorBuilder.AttributeData data) {
        CuriosApi.addSlotModifier((Multimap)m, (String)slot, (UUID)uuid, (double)data.value(), (AttributeModifier.Operation)data.operation());
    }

    private static /* synthetic */ void lambda$getAttributeModifiers$0(UUID uuid, Multimap m, Supplier attrSupplier, AbstractArmorBuilder.AttributeData data) {
        AttributeModifier modifier1 = new AttributeModifier(uuid, "Attribute Modifier", (double)data.value(), data.operation());
        m.put((Object)((Attribute)attrSupplier.get()), (Object)modifier1);
    }

    public static class Builder
    extends AbstractCurioBuilder<CurioAccessoryItem, Builder> {
        public Builder(Tier tier, Item.Properties properties) {
            super(tier, properties);
        }

        @Override
        public CurioAccessoryItem build() {
            return new CurioAccessoryItem(this);
        }
    }
}

