/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio;

import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.RegistryObject;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.interfaces.ParticleItemEntity;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.util.Tmp;
import pro.komaru.tridot.util.math.ArcRandom;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class BloodSight
extends Item
implements ICurioItem,
Vanishable,
ParticleItemEntity {
    private int hits = 0;
    public ArcRandom arcRandom = Tmp.rnd;

    public BloodSight(Item.Properties properties) {
        super(properties);
    }

    public boolean canEquipFromUse(SlotContext slot, ItemStack stack) {
        return true;
    }

    public boolean m_8120_(ItemStack pStack) {
        return false;
    }

    public int getDamage(RandomSource pRandom) {
        return 1 + pRandom.m_188503_(3);
    }

    public void hitLast(Level pLevel, Player pPlayer, float pAmount) {
        LivingEntity lastHurtMob = pPlayer.m_271686_();
        if (!pLevel.m_5776_() && pLevel instanceof ServerLevel) {
            ServerLevel pServer = (ServerLevel)pLevel;
            if (lastHurtMob == null) {
                return;
            }
            lastHurtMob.m_6469_(pServer.m_269111_().m_269425_(), pAmount);
        }
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        int damageAmount;
        Player player = (Player)slotContext.entity();
        Level pLevel = player.m_9236_();
        LivingEntity lastHurtMob = player.m_271686_();
        boolean flag = stack.m_41720_() == ItemsRegistry.monocle.get();
        int duration = flag ? 12 : 6;
        int n = damageAmount = flag ? Tmp.rnd.nextInt(2, 6) : Tmp.rnd.nextInt(2, 8);
        if (!pLevel.m_5776_() && pLevel instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)pLevel;
            if (lastHurtMob != null && !player.m_36335_().m_41519_(stack.m_41720_())) {
                this.hitLast((Level)serverLevel, player, this.getDamage(RandomSource.m_216327_()));
                if (!flag && this.arcRandom.chance(0.25f)) {
                    player.m_6469_(pLevel.m_269111_().m_269425_(), 0.5f);
                }
                if (lastHurtMob.f_19864_) {
                    ++this.hits;
                }
                Utils.Particles.lineToAttacked((Level)serverLevel, (Player)player, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), (int)duration);
                if (player.f_19864_) {
                    stack.m_41622_(damageAmount, (LivingEntity)player, p0 -> p0.m_21166_(EquipmentSlot.MAINHAND));
                }
                if (this.hits >= duration / 2) {
                    stack.m_41622_(damageAmount, (LivingEntity)player, p0 -> p0.m_21166_(EquipmentSlot.MAINHAND));
                    player.m_36335_().m_41524_(stack.m_41720_(), 600);
                    this.hits = 0;
                }
            }
        }
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return true;
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return stack.m_41720_() == ItemsRegistry.monocle.get() ? new ICurio.SoundInfo(SoundEvents.f_11672_, 1.0f, 1.0f) : new ICurio.SoundInfo((SoundEvent)SoundsRegistry.EQUIP_CURSE.get(), 1.0f, 1.0f);
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.bloodsight").m_130940_(ChatFormatting.GRAY));
        if (stack.m_41720_() == ItemsRegistry.brokenMonocle.get()) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.bloodsight_curse").m_130940_(ChatFormatting.RED).m_130940_(ChatFormatting.ITALIC));
        }
    }

    public void spawnParticles(Level level, ItemEntity entity) {
        if (entity.m_32055_().m_150930_((Item)ItemsRegistry.brokenMonocle.get())) {
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.SKULL).randomVelocity((double)0.05f, (double)0.04f, (double)0.05f)).setTransparencyData(GenericParticleData.create((float)0.1f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.1f, (float)0.0f).build()).setColorData(ColorParticleData.create((float)0.666f, (float)0.343f, (float)0.315f, (float)0.915f, (float)0.225f, (float)0.915f).build()).setLifetime(15).spawn(level, entity.m_20185_() + (Tmp.rnd.nextDouble() - 0.5) / 2.0, entity.m_20186_() + (new Random().nextDouble() + (double)0.1f) / 2.0, entity.m_20189_());
        } else {
            ((ParticleBuilder)ParticleBuilder.create((RegistryObject)TridotParticles.TINY_WISP).randomVelocity(0.0, (double)0.04f, 0.0)).setTransparencyData(GenericParticleData.create((float)0.25f, (float)0.0f).build()).setScaleData(GenericParticleData.create((float)0.1f, (float)0.0f).build()).setColorData(ColorParticleData.create((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.915f).build()).setLifetime(45).spawn(level, entity.m_20185_() + (Tmp.rnd.nextDouble() - 0.5) / 2.0, entity.m_20186_() + (new Random().nextDouble() + (double)0.1f) / 2.0, entity.m_20189_());
        }
    }
}

