/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types.curio;

import com.idark.valoria.registries.EffectsRegistry;
import com.idark.valoria.registries.TagsRegistry;
import com.idark.valoria.util.Pal;
import com.idark.valoria.util.Styles;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.util.Tmp;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public abstract class AbstractTieredAccessory
extends TieredItem
implements ICurioItem,
Vanishable {
    public Tier tier;
    public boolean rmbEquip;

    public AbstractTieredAccessory(Tier tier, Item.Properties pProperties) {
        super(tier, pProperties);
        this.tier = tier;
        this.rmbEquip = true;
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        if (this.tier == Tiers.IRON) {
            return new ICurio.SoundInfo(SoundEvents.f_11677_, 1.0f, 1.0f);
        }
        if (this.tier == Tiers.GOLD) {
            return new ICurio.SoundInfo(SoundEvents.f_11676_, 1.0f, 1.0f);
        }
        if (this.tier == Tiers.DIAMOND) {
            return new ICurio.SoundInfo(SoundEvents.f_11673_, 1.0f, 1.0f);
        }
        if (this.tier == Tiers.NETHERITE) {
            return new ICurio.SoundInfo(SoundEvents.f_11679_, 1.0f, 1.0f);
        }
        return new ICurio.SoundInfo(SoundEvents.f_11675_, 1.0f, 1.0f);
    }

    public boolean canEquipFromUse(SlotContext slot, ItemStack stack) {
        return this.rmbEquip;
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        Player player = (Player)slotContext.entity();
        if (player.f_19864_) {
            AbstractTieredAccessory.accessoryHurt(player, stack, this.tier);
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchant) {
        return enchant == Enchantments.f_44963_ || enchant == Enchantments.f_44986_ || enchant == Enchantments.f_44962_;
    }

    public boolean makesPiglinsNeutral(SlotContext slotContext, ItemStack stack) {
        return this.tier == Tiers.GOLD;
    }

    public static void accessoryHurt(Player player, ItemStack stack, Tier material) {
        int pGoldDamage = Tmp.rnd.nextInt(0, 8);
        int pDefaultDamage = Tmp.rnd.nextInt(0, 2);
        stack.m_41622_(material == Tiers.GOLD ? pGoldDamage : pDefaultDamage, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        if (stack.m_204117_(TagsRegistry.GRANTS_IMMUNITIES)) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.immunity", (Object[])new Object[]{MobEffects.f_19614_.m_19482_()}).m_130940_(ChatFormatting.GRAY));
            if (stack.m_204117_(TagsRegistry.POISON_IMMUNE)) {
                tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"tooltip.tridot.value", (Object[])new Object[]{MobEffects.f_19614_.m_19482_()}).m_130948_((Style)Styles.nature)));
            }
            if (stack.m_204117_(TagsRegistry.BLEEDING_IMMUNE)) {
                tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"tooltip.tridot.value", (Object[])new Object[]{((MobEffect)EffectsRegistry.BLEEDING.get()).m_19482_()}).m_130948_((Style)Styles.create(Pal.strongRed))));
            }
            if (stack.m_204117_(TagsRegistry.FIRE_IMMUNE)) {
                tooltip.add((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237110_((String)"tooltip.tridot.value", (Object[])new Object[]{Blocks.f_50083_.m_49954_()}).m_130948_((Style)Styles.create(Pal.infernalBright))));
            }
        }
        if (stack.m_204117_(TagsRegistry.INFLICTS_FIRE)) {
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.inflicts_fire").m_130940_(ChatFormatting.GRAY));
        }
    }
}

