/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.google.common.collect.Sets;
import com.idark.valoria.Valoria;
import com.idark.valoria.core.interfaces.StoneCrushable;
import com.idark.valoria.registries.TagsRegistry;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.client.gfx.text.DotStyle;

public class ValoriaMultiTool
extends DiggerItem
implements StoneCrushable {
    Tier tier;
    private static final Set<ToolAction> TOOL_ACTIONS = Stream.of(ToolActions.AXE_DIG, ToolActions.AXE_STRIP, ToolActions.AXE_SCRAPE, ToolActions.AXE_WAX_OFF, ToolActions.PICKAXE_DIG, ToolActions.SHOVEL_DIG, ToolActions.HOE_DIG, ToolActions.HOE_TILL).collect(Collectors.toCollection(Sets::newIdentityHashSet));

    public ValoriaMultiTool(Tier pTier, float pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pAttackDamageModifier, pAttackSpeedModifier, pTier, TagsRegistry.MINEABLE_WITH_MULTITOOL, pProperties);
        this.tier = pTier;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level level, List<Component> tooltip, TooltipFlag flagIn) {
        tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.efficiency", (Object[])new Object[]{Float.valueOf(this.f_40980_)}).m_130940_(ChatFormatting.GRAY).m_130948_((Style)DotStyle.of().font(Valoria.FONT)));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.harvest", (Object[])new Object[]{this.m_43314_().m_6604_()}).m_130940_(ChatFormatting.GRAY).m_130948_((Style)DotStyle.of().font(Valoria.FONT)));
    }

    public boolean isCorrectTags(BlockState state) {
        return state.m_204336_(TagsRegistry.MINEABLE_WITH_MULTITOOL);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return this.isCorrectTags(state) && TierSortingRegistry.isCorrectTierForDrops((Tier)this.tier, (BlockState)state);
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        return this.isCorrectTags(state) ? this.f_40980_ : super.m_8102_(stack, state);
    }

    public InteractionResult m_6225_(UseOnContext pContext) {
        Pair pair;
        Level level = pContext.m_43725_();
        BlockPos blockpos = pContext.m_8083_();
        Player player = pContext.m_43723_();
        BlockState blockstate = level.m_8055_(blockpos);
        BlockState toolModifiedState = level.m_8055_(blockpos).getToolModifiedState(pContext, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)HoeItem.m_150858_((BlockState)toolModifiedState));
        if (pair != null) {
            return ValoriaMultiTool.performHoeBehaviour(pContext, (Pair<Predicate<UseOnContext>, Consumer<UseOnContext>>)pair, level, player, blockpos);
        }
        AxeResult result = ValoriaMultiTool.getAxeResult(pContext, blockstate, level, player, blockpos);
        if (result.optional3().isPresent()) {
            return ValoriaMultiTool.performAxeBehaviour(pContext, player, blockpos, result, level);
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static InteractionResult performHoeBehaviour(UseOnContext pContext, Pair<Predicate<UseOnContext>, Consumer<UseOnContext>> pair, Level level, Player player, BlockPos blockpos) {
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(pContext)) {
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(pContext);
                if (player != null) {
                    pContext.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(pContext.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return null;
    }

    @NotNull
    private static InteractionResult performAxeBehaviour(UseOnContext pContext, Player player, BlockPos blockpos, AxeResult result, Level level) {
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10562_.m_285767_((ServerPlayer)player, blockpos, result.itemstack());
        }
        level.m_7731_(blockpos, result.optional3().get(), 11);
        level.m_220407_(GameEvent.f_157792_, blockpos, GameEvent.Context.m_223719_((Entity)player, (BlockState)result.optional3().get()));
        if (player != null) {
            result.itemstack().m_41622_(1, (LivingEntity)player, p_150686_ -> p_150686_.m_21190_(pContext.m_43724_()));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    @NotNull
    private static AxeResult getAxeResult(UseOnContext pContext, BlockState blockstate, Level level, Player player, BlockPos blockpos) {
        Optional<BlockState> optional = Optional.ofNullable(blockstate.getToolModifiedState(pContext, ToolActions.AXE_STRIP, false));
        Optional optional1 = optional.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(pContext, ToolActions.AXE_SCRAPE, false));
        Optional optional2 = optional.isPresent() || optional1.isPresent() ? Optional.empty() : Optional.ofNullable(blockstate.getToolModifiedState(pContext, ToolActions.AXE_WAX_OFF, false));
        ItemStack itemstack = pContext.m_43722_();
        Optional<Object> optional3 = Optional.empty();
        if (optional.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            optional3 = optional;
        } else if (optional1.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144059_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3005, blockpos, 0);
            optional3 = optional1;
        } else if (optional2.isPresent()) {
            level.m_5594_(player, blockpos, SoundEvents.f_144060_, SoundSource.BLOCKS, 1.0f, 1.0f);
            level.m_5898_(player, 3004, blockpos, 0);
            optional3 = optional2;
        }
        return new AxeResult(itemstack, optional3);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return TOOL_ACTIONS.contains(toolAction);
    }

    private record AxeResult(ItemStack itemstack, Optional<BlockState> optional3) {
    }
}

