/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.types;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.config.ClientConfig;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.item.ISoulItem;
import com.idark.valoria.util.ValoriaUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import pro.komaru.tridot.api.interfaces.OverlayRenderItem;

public class SoulCollectorItem
extends Item
implements OverlayRenderItem,
ISoulItem {
    public int max;
    public int base;
    public static final ResourceLocation BAR = new ResourceLocation("valoria", "textures/gui/overlay/soul_collector.png");

    public SoulCollectorItem(Item.Properties pProperties) {
        super(pProperties.m_41503_(5));
        this.max = 50;
        this.base = 0;
    }

    public SoulCollectorItem(int max, Item.Properties pProperties) {
        super(pProperties.m_41503_(5));
        this.max = max;
        this.base = 0;
    }

    public SoulCollectorItem(int max, int base, Item.Properties pProperties) {
        super(pProperties.m_41503_(5));
        this.max = max;
        this.base = base;
    }

    public ItemStack m_7968_() {
        return this.setSoulItem(super.m_7968_());
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        super.m_7373_(stack, world, tooltip, flags);
        tooltip.add((Component)Component.m_237115_((String)"tooltip.valoria.soul_collector").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237110_((String)"tooltip.valoria.souls", (Object[])new Object[]{this.getCurrentSouls(stack)}).m_130946_(" / ").m_130946_(String.valueOf(this.getMaxSouls())).m_130940_(ChatFormatting.GRAY).m_130946_("\ue253").m_130938_(style -> style.m_131150_(Valoria.FONT)));
    }

    public boolean m_142522_(ItemStack pStack) {
        return this.barVisible(pStack);
    }

    public int m_142158_(ItemStack pStack) {
        return this.barWidth(pStack);
    }

    public int m_142159_(ItemStack pStack) {
        return this.barColor();
    }

    public ResourceLocation getTexture() {
        return BAR;
    }

    @Override
    public int getBaseSouls() {
        return this.base;
    }

    @Override
    public int getMaxSouls() {
        return this.max;
    }

    @Override
    public void consumeSouls(int count, ItemStack pStack) {
        int souls = Math.max(this.getCurrentSouls(pStack) - count, 0);
        pStack.m_41784_().m_128405_("Souls", souls);
        if (souls == 0) {
            ItemStack itemstack = pStack.m_41777_();
            CompoundTag compoundtag = pStack.m_41783_();
            if (compoundtag != null) {
                compoundtag.m_128473_("Souls");
                compoundtag.m_128405_("Souls", souls);
                itemstack.m_41751_(compoundtag.m_6426_());
            }
        }
    }

    @Override
    public void addCount(int count, ItemStack pStack, Player player) {
        if (pStack.m_41784_().m_128451_("Souls") + count >= this.getMaxSouls() - 1) {
            player.m_150109_().m_36057_(pStack);
            ValoriaUtils.addPlayerItem(player.m_9236_(), player, ((Item)ItemsRegistry.soulCollector.get()).m_7968_());
            player.m_9236_().m_5594_(null, player.m_20097_(), this.getTransformSound(), SoundSource.PLAYERS, 1.0f, player.m_9236_().f_46441_.m_188501_());
        } else {
            pStack.m_41784_().m_128405_("Souls", this.getCurrentSouls(pStack) + count);
            player.m_9236_().m_5594_(null, player.m_20097_(), this.getCollectSound(), SoundSource.PLAYERS, 1.0f, player.m_9236_().f_46441_.m_188501_());
        }
    }

    public SoundEvent getTransformSound() {
        return (SoundEvent)SoundsRegistry.SOUL_COLLECT_FULL.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(CompoundTag tag, GuiGraphics gui, int offsetX, int offsetY) {
        int xCord = (Integer)ClientConfig.MISC_UI_X.get() + offsetX;
        int yCord = (Integer)ClientConfig.MISC_UI_Y.get() + offsetY;
        int progress = 22;
        progress = (int)((double)progress / ((double)this.getMaxSouls() / (double)tag.m_128451_("Souls")));
        gui.m_280163_(BAR, xCord, yCord, 0.0f, 0.0f, 24, 48, 48, 48);
        gui.m_280163_(BAR, xCord + 6, yCord + 39 - (int)((double)progress * 1.5), 36.0f, (float)(33 - (int)((double)progress * 1.5)), 12, (int)((double)progress * 1.5), 48, 48);
    }
}

