/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class TinkeringRecipe
implements Recipe<Container> {
    protected final Ingredient ingredient;
    protected final int ingredientCount;
    protected final ItemStack result;
    protected final ResourceLocation id;
    protected final String group;

    public TinkeringRecipe(ResourceLocation pId, String pGroup, Ingredient pIngredient, int pIngredientCount, ItemStack pResult) {
        this.id = pId;
        this.group = pGroup;
        this.ingredient = pIngredient;
        this.ingredientCount = pIngredientCount;
        this.result = pResult;
    }

    public RecipeType<?> m_6671_() {
        return Type.INSTANCE;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public int getIngredientCount() {
        return this.ingredientCount;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.ingredient);
        return nonnulllist;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public boolean canCraft(Container pContainer) {
        ItemStack stackInSlot = pContainer.m_8020_(0);
        return this.ingredient.test(stackInSlot) && stackInSlot.m_41613_() >= this.ingredientCount;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        ItemStack stackInSlot = pContainer.m_8020_(0);
        return this.ingredient.test(stackInSlot);
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        ItemStack stackInSlot = pContainer.m_8020_(0);
        if (stackInSlot.m_41613_() >= this.ingredientCount) {
            return this.result.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public static class Type
    implements RecipeType<TinkeringRecipe> {
        public static final Type INSTANCE = new Type();
        public static final String ID = "tinkering";
    }

    public static class Serializer
    implements RecipeSerializer<TinkeringRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("valoria", "tinkering");

        public TinkeringRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            String s = GsonHelper.m_13851_((JsonObject)pJson, (String)"group", (String)"");
            Ingredient ingredient = GsonHelper.m_13885_((JsonObject)pJson, (String)"ingredient") ? Ingredient.m_288218_((JsonElement)GsonHelper.m_13933_((JsonObject)pJson, (String)"ingredient"), (boolean)false) : Ingredient.m_288218_((JsonElement)GsonHelper.m_13930_((JsonObject)pJson, (String)"ingredient"), (boolean)false);
            int ingredientCount = GsonHelper.m_13824_((JsonObject)pJson, (String)"ingredient_count", (int)1);
            String s1 = GsonHelper.m_13906_((JsonObject)pJson, (String)"result");
            int i = GsonHelper.m_13927_((JsonObject)pJson, (String)"count");
            ItemStack itemstack = new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(new ResourceLocation(s1)), i);
            return new TinkeringRecipe(pRecipeId, s, ingredient, ingredientCount, itemstack);
        }

        public TinkeringRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            String s = pBuffer.m_130277_();
            Ingredient ingredient = Ingredient.m_43940_((FriendlyByteBuf)pBuffer);
            int ingredientCount = pBuffer.m_130242_();
            ItemStack itemstack = pBuffer.m_130267_();
            return new TinkeringRecipe(pRecipeId, s, ingredient, ingredientCount, itemstack);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, TinkeringRecipe pRecipe) {
            pBuffer.m_130070_(pRecipe.group);
            pRecipe.ingredient.m_43923_(pBuffer);
            pBuffer.m_130130_(pRecipe.ingredientCount);
            pBuffer.m_130055_(pRecipe.result);
        }
    }
}

