/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.item.armor.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.idark.valoria.client.render.armor.SamuraiArmorRenderer;
import com.idark.valoria.registries.AttributeReg;
import com.idark.valoria.registries.ItemsRegistry;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.client.model.armor.ArmorModel;
import pro.komaru.tridot.common.registry.item.armor.SuitArmorItem;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.renderer.GeoArmorRenderer;
import software.bernie.geckolib.util.GeckoLibUtil;

public class SamuraiArmorItem
extends SuitArmorItem
implements GeoItem {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public SamuraiArmorItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties) {
        super(material, type, properties);
    }

    @Nullable
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "minecraft:textures/models/armor/diamond_layer_1.png";
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private GeoArmorRenderer<?> renderer;

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                ArmorModel model = SamuraiArmorItem.this.getArmorModel(livingEntity, itemStack, equipmentSlot, original);
                if (model != null) {
                    return model;
                }
                if (this.renderer == null) {
                    this.renderer = new SamuraiArmorRenderer();
                }
                this.renderer.prepForRender((Entity)livingEntity, itemStack, equipmentSlot, original);
                return this.renderer;
            }
        });
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{new AnimationController((GeoAnimatable)this, 20, state -> {
            state.setAnimation(DefaultAnimations.IDLE);
            Entity entity = (Entity)state.getData(DataTickets.ENTITY);
            if (entity instanceof ArmorStand) {
                return PlayState.CONTINUE;
            }
            ObjectOpenHashSet wornArmor = new ObjectOpenHashSet();
            for (ItemStack stack : entity.m_6168_()) {
                if (stack.m_41619_()) {
                    return PlayState.STOP;
                }
                wornArmor.add(stack.m_41720_());
            }
            boolean isFullSet = wornArmor.containsAll((Collection<?>)ObjectArrayList.of((Object[])new Item[]{(Item)ItemsRegistry.samuraiBoots.get(), (Item)ItemsRegistry.samuraiLeggings.get(), (Item)ItemsRegistry.samuraiChestplate.get(), (Item)ItemsRegistry.samuraiKabuto.get()}));
            return isFullSet ? PlayState.CONTINUE : PlayState.STOP;
        })});
    }

    public float getBonusValue(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.CHEST -> 0.15f;
            case EquipmentSlot.HEAD, EquipmentSlot.FEET -> 0.05f;
            case EquipmentSlot.LEGS -> 0.1f;
            default -> 0.0f;
        };
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot slot) {
        ImmutableMultimap.Builder atts = ImmutableMultimap.builder();
        atts.putAll(super.m_7167_(slot));
        atts.put((Object)((Attribute)AttributeReg.DASH_DISTANCE.get()), (Object)new AttributeModifier(UUID.fromString("58c87772-fa46-4635-8877-72fa464635a6"), "bonus", (double)this.getBonusValue(slot), AttributeModifier.Operation.ADDITION));
        return slot == this.f_265916_.m_266308_() ? atts.build() : super.m_7167_(slot);
    }
}

