/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.projectile;

import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.ItemsRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.projectile.AbstractSupplierProjectile;
import com.idark.valoria.registries.entity.projectile.PyratiteShard;
import com.idark.valoria.util.Pal;
import java.util.function.Consumer;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;
import pro.komaru.tridot.client.gfx.TridotParticles;
import pro.komaru.tridot.client.gfx.particle.GenericParticle;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.behavior.TrailParticleBehavior;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.render.TridotRenderTypes;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeHandler;
import pro.komaru.tridot.client.render.screenshake.ScreenshakeInstance;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.math.Interp;

public class ThrownSpearEntity
extends AbstractSupplierProjectile {
    private float explosive_radius;
    private boolean shouldExplode;
    private boolean isExploded;
    private boolean isPyratiteHit;
    private Level.ExplosionInteraction interaction;

    public ThrownSpearEntity(Level worldIn, LivingEntity thrower, ItemStack thrownStackIn) {
        super((EntityType<? extends AbstractArrow>)((EntityType)EntityTypeRegistry.SPEAR.get()), worldIn, thrower, thrownStackIn);
        this.setItem(thrownStackIn);
    }

    public ThrownSpearEntity(EntityType<? extends ThrownSpearEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    protected float m_6882_() {
        if (this.m_7846_().m_150930_((Item)ItemsRegistry.aquariusSpear.get())) {
            return 0.99f;
        }
        return super.m_6882_();
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticlesTrail() {
        if (!this.f_36703_) {
            Vec3 delta = this.m_20184_().m_82541_();
            Vec3 pos = new Vec3(this.m_20185_() + delta.m_7096_() * 1.5E-4, this.m_20186_() + delta.m_7098_() * 1.5E-4, this.m_20189_() + delta.m_7094_() * 1.5E-4);
            Vec3[] cachePos = new Vec3[]{new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_)};
            Consumer<GenericParticle> target = p -> {
                Vec3 arrowPos = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
                float lenBetweenArrowAndParticle = (float)arrowPos.m_82546_(cachePos[0]).m_82553_();
                Vec3 vector = arrowPos.m_82546_(cachePos[0]);
                if (lenBetweenArrowAndParticle > 0.0f) {
                    cachePos[0] = cachePos[0].m_82549_(vector);
                    p.setPosition(cachePos[0]);
                }
            };
            Style base = Style.f_131099_;
            Style styled = (Style)this.m_7846_().m_41791_().getStyleModifier().apply(base);
            Col color = styled.m_131135_() != null ? Col.fromARGB((int)styled.m_131135_().m_131265_()) : Pal.darkerGray.brighter();
            ParticleBuilder.create((RegistryObject)TridotParticles.TRAIL).setRenderType(TridotRenderTypes.ADDITIVE_PARTICLE_TEXTURE).setBehavior(TrailParticleBehavior.create().build()).setColorData(ColorParticleData.create((Col)color).build()).setTransparencyData(GenericParticleData.create((float)0.5f, (float)0.0f).setEasing(Interp.sineOut).build()).setScaleData(GenericParticleData.create((float)0.5f).setEasing(Interp.sineIn).build()).addTickActor(target).setGravity(0.0f).setLifetime(10).spawn(this.m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_);
        }
    }

    @NotNull
    public SoundEvent m_7239_() {
        return (SoundEvent)SoundsRegistry.SPEAR_GROUND_IMPACT.get();
    }

    @NotNull
    public SoundEvent m_36784_() {
        return (SoundEvent)SoundsRegistry.SPEAR_GROUND_IMPACT.get();
    }

    @Override
    public SoundEvent getReturnSound() {
        return (SoundEvent)SoundsRegistry.SPEAR_RETURN.get();
    }

    public void setExplode(Level.ExplosionInteraction pInteraction, float radius) {
        this.shouldExplode = true;
        this.interaction = pInteraction;
        this.explosive_radius = radius;
    }

    private void summonStormCrystal(ServerLevel serverLevel, Vec3 spawnPos, float angle, double speed) {
        PyratiteShard shard = (PyratiteShard)((EntityType)EntityTypeRegistry.PYRATITE_SHARD.get()).m_20615_(this.m_9236_());
        if (shard != null) {
            shard.m_7678_(spawnPos.m_7096_(), spawnPos.m_7098_() + 2.0, spawnPos.m_7094_(), 0.0f, 0.0f);
            shard.m_5602_(this.m_19749_());
            double vx = Math.cos(angle) * speed;
            double vz = Math.sin(angle) * speed;
            shard.m_20334_(vx, 0.4, vz);
            serverLevel.m_7967_((Entity)shard);
        }
    }

    @Override
    protected void m_6532_(HitResult pResult) {
        Level level;
        super.m_6532_(pResult);
        if (!this.isPyratiteHit && this.m_7846_().m_150930_((Item)ItemsRegistry.pyratiteSpear.get()) && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serv = (ServerLevel)level;
            for (int i = 0; i < 4; ++i) {
                float angle = (float)(1.5707963267948966 * (double)i);
                this.summonStormCrystal(serv, pResult.m_82450_(), angle, 0.05);
            }
            this.isPyratiteHit = true;
        }
        if (this.shouldExplode && !this.isExploded) {
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_254849_(this.m_19749_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), this.explosive_radius, this.interaction);
                ScreenshakeHandler.add((ScreenshakeInstance)new ScreenshakeInstance(3).intensity(0.75f));
            }
            this.isExploded = true;
        }
    }
}

