/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.boss;

import com.idark.valoria.Valoria;
import com.idark.valoria.core.config.CommonConfig;
import com.idark.valoria.core.network.PacketHandler;
import com.idark.valoria.core.network.packets.particle.BeastAttackParticlePacket;
import com.idark.valoria.registries.BlockRegistry;
import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.SoundsRegistry;
import com.idark.valoria.registries.entity.ai.movements.FlyingAroundMovement;
import com.idark.valoria.registries.entity.living.minions.CrystalEntity;
import com.idark.valoria.registries.entity.living.minions.WickedShield;
import com.idark.valoria.registries.entity.projectile.CrystalShard;
import com.idark.valoria.registries.entity.projectile.CrystalSpikes;
import com.idark.valoria.util.Pal;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.api.render.bossbars.ServerBossBar;
import pro.komaru.tridot.common.registry.entity.AbstractBoss;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;
import pro.komaru.tridot.util.Tmp;

public class WickedCrystal
extends AbstractBoss {
    public final ServerBossBar bossEvent = new ServerBossBar(this.m_5446_(), Valoria.loc("basic")).setTexture(Valoria.loc("textures/gui/bossbars/wicked_crystal.png")).setDarkenScreen(true);
    public AnimationState spawnAnimationState = new AnimationState();
    public AnimationState deathAnimationState = new AnimationState();
    public int animatedDeathTime = 0;
    public int phase = 1;

    public WickedCrystal(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 200;
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            this.deathAnimationState.m_216977_(this.f_19797_);
        } else if (pId == 20) {
            this.spawnAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(pId);
        }
    }

    public void m_8119_() {
        Level level;
        super.m_8119_();
        this.checkPhaseTransition();
        if (this.animatedDeathTime > 0 && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 2; ++i) {
                double offsetX = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                double offsetY = this.f_19796_.m_188500_() * 0.4;
                double offsetZ = (this.f_19796_.m_188500_() - 0.5) * 0.6;
                serverLevel.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)BlockRegistry.wickedAmethystBlock.get()).m_49966_()), this.m_20185_() + offsetX, this.m_20186_() + 0.5 + offsetY, this.m_20189_() + offsetZ, 1, 0.0, 0.5, 0.0, 0.05);
            }
        }
    }

    public void m_6667_(DamageSource pDamageSource) {
        TargetingConditions targetingConditions = TargetingConditions.m_148353_().m_26883_(32.0).m_148355_().m_26893_();
        List shieldsInArea = this.m_9236_().m_45971_(WickedShield.class, targetingConditions, (LivingEntity)this, this.m_20191_().m_82400_(16.0));
        for (Entity entity : shieldsInArea) {
            entity.m_146870_();
        }
        List crystalsInArea = this.m_9236_().m_45971_(CrystalEntity.class, targetingConditions, (LivingEntity)this, this.m_20191_().m_82400_(16.0));
        for (Entity entity : crystalsInArea) {
            entity.m_146870_();
        }
        this.bossEvent.setAboutToDie(true);
        super.m_6667_(pDamageSource);
    }

    protected void m_6153_() {
        ++this.animatedDeathTime;
        if (this.animatedDeathTime >= 30 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void checkPhaseTransition() {
        if (this.m_21223_() <= this.m_21233_() / 2.0f && this.phase == 1 && !this.m_9236_().m_5776_()) {
            this.phase = 2;
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ((Block)BlockRegistry.wickedAmethystBlock.get()).m_49966_()), this.m_20185_(), this.m_20186_() + 5.0, this.m_20189_(), 25, 0.0, 0.0, 0.0, 0.0);
            this.m_5496_((SoundEvent)SoundsRegistry.WICKED_CRYSTAL_TRANSFORM.get(), 1.0f, 1.0f);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (this.m_8077_()) {
            this.bossEvent.setName(this.m_5446_());
        }
    }

    public void m_6593_(@javax.annotation.Nullable Component pName) {
        super.m_6593_(pName);
        this.bossEvent.setName(this.m_5446_());
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        this.bossEvent.addPlayer(pPlayer);
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.bossEvent.removePlayer(pPlayer);
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossEvent.setHealth(this.m_21223_(), this.m_21233_());
    }

    protected void m_7324_(@NotNull Entity pEntity) {
    }

    public void m_147240_(double strength, double x, double z) {
    }

    protected void m_6138_() {
        List list = this.m_9236_().m_6249_((Entity)this, this.m_20191_(), p_31582_ -> p_31582_ instanceof LivingEntity);
        for (Entity entity : list) {
            if (!(this.m_20280_(entity) <= 1.0)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && source.m_7639_().m_20186_() > this.m_20186_() + 6.0) {
            return false;
        }
        TargetingConditions shields = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_();
        int shieldCount = this.m_9236_().m_45971_(WickedShield.class, shields, (LivingEntity)this, this.m_20191_().m_82400_(16.0)).size();
        float damage = amount;
        for (int i = 0; i < shieldCount; ++i) {
            damage /= 2.0f;
        }
        return super.m_6469_(source, damage);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsRegistry.WICKED_CRYSTAL_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsRegistry.WICKED_CRYSTAL_DEATH.get();
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(1, (Goal)new PullTowardsGoal());
        this.f_21345_.m_25352_(1, (Goal)new SummonShieldsGoal());
        this.f_21345_.m_25352_(1, (Goal)new SummonSpellGoal());
        this.f_21345_.m_25352_(1, (Goal)new RadialAttack());
        this.f_21345_.m_25352_(1, (Goal)new CrystalStorm());
    }

    public class PullTowardsGoal
    extends MultiAttackMob.AttackGoal {
        Vec3 lastPos;
        int idleTicks;

        public PullTowardsGoal() {
            super((MultiAttackMob)WickedCrystal.this);
            this.idleTicks = 0;
        }

        public void onPrepare() {
            LivingEntity livingEntity = WickedCrystal.this.m_5448_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                this.lastPos = player.m_20182_();
            }
        }

        public void m_8037_() {
            super.m_8037_();
            LivingEntity livingEntity = WickedCrystal.this.m_5448_();
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                Vec3 currentPos = player.m_20182_();
                if (currentPos.m_82557_(this.lastPos) < 0.01) {
                    ++this.idleTicks;
                } else {
                    this.idleTicks = 0;
                    this.lastPos = currentPos;
                }
                if (this.idleTicks > 40) {
                    this.pullTowardsBoss(player);
                }
            }
        }

        public void pullTowardsBoss(Player player) {
            Vec3 dir = WickedCrystal.this.m_20182_().m_82546_(player.m_20182_()).m_82541_().m_82490_(2.0);
            player.m_20256_(dir);
            player.m_6135_();
            player.f_19864_ = true;
            Utils.Particles.line((Level)WickedCrystal.this.m_9236_(), (Vec3)WickedCrystal.this.m_20182_(), (Vec3)player.m_20182_(), (ParticleOptions)ParticleTypes.f_123792_);
        }

        protected void performAttack() {
            WickedCrystal.this.m_216990_(SoundEvents.f_11867_);
        }

        public int getPreparingTime() {
            return 40;
        }

        public int getAttackInterval() {
            return 125;
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return SoundEvents.f_271165_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.MAGIC;
        }
    }

    public class SummonShieldsGoal
    extends MultiAttackMob.AttackGoal {
        private final TargetingConditions shieldCount;

        public SummonShieldsGoal() {
            super((MultiAttackMob)WickedCrystal.this);
            this.shieldCount = TargetingConditions.m_148353_().m_26883_(8.0).m_148355_().m_26893_();
        }

        public boolean m_8036_() {
            int i = WickedCrystal.this.m_9236_().m_45971_(WickedShield.class, this.shieldCount, (LivingEntity)WickedCrystal.this, WickedCrystal.this.m_20191_().m_82400_(16.0)).size();
            return super.m_8036_() && i < (Integer)CommonConfig.SHIELDS_WICKED_CRYSTAL_LIMIT.get();
        }

        private void summonShield(ServerLevel serverLevel, BlockPos blockpos, float angle) {
            WickedShield shield = (WickedShield)((EntityType)EntityTypeRegistry.WICKED_SHIELD.get()).m_20615_(WickedCrystal.this.m_9236_());
            if (shield != null && serverLevel.m_46859_(blockpos)) {
                shield.m_20035_(blockpos, 0.0f, 0.0f);
                shield.m_6518_((ServerLevelAccessor)serverLevel, WickedCrystal.this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                shield.setOwner((Entity)WickedCrystal.this);
                shield.movement = new FlyingAroundMovement((Mob)shield, (Entity)WickedCrystal.this);
                shield.movement.setRadius(2.0f);
                shield.movement.setAngle(angle);
                serverLevel.m_7967_((Entity)shield);
            }
        }

        public void onPrepare() {
        }

        protected void performAttack() {
            boolean flag;
            WickedCrystal entity = WickedCrystal.this;
            boolean bl = flag = entity.m_9236_().f_46443_ || !entity.hasTarget();
            if (flag) {
                return;
            }
            Level level = entity.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serv = (ServerLevel)level;
                int phase1 = (Integer)CommonConfig.SHIELDS_WICKED_CRYSTAL_COUNT_PHASE1.get();
                int phase2 = (Integer)CommonConfig.SHIELDS_WICKED_CRYSTAL_COUNT_PHASE2.get();
                for (int i = 0; i < (WickedCrystal.this.phase == 1 ? phase1 : phase2); ++i) {
                    float initialAngle = (float)(Math.PI * 2 / (double)(WickedCrystal.this.phase == 1 ? phase1 : phase2) * (double)i);
                    this.summonShield(serv, WickedCrystal.this.m_20183_().m_7494_(), initialAngle);
                }
            }
        }

        public int getPreparingTime() {
            return (Integer)CommonConfig.SHIELDS_WICKED_CRYSTAL_CASTING_TIME.get();
        }

        public int getAttackInterval() {
            return (Integer)CommonConfig.SHIELDS_WICKED_CRYSTAL_CASTING_INTERVAL.get();
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.BLOCK;
        }
    }

    public class SummonSpellGoal
    extends MultiAttackMob.AttackGoal {
        public SummonSpellGoal() {
            super((MultiAttackMob)WickedCrystal.this);
        }

        public void onPrepare() {
        }

        protected void performAttack() {
            Level level = WickedCrystal.this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serv = (ServerLevel)level;
                this.spawn(serv);
            }
        }

        public int getPreparingTime() {
            return (Integer)CommonConfig.SUMMON_WICKED_CRYSTAL_CASTING_TIME.get();
        }

        public int getAttackInterval() {
            return (Integer)CommonConfig.SUMMON_WICKED_CRYSTAL_CASTING_INTERVAL.get();
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return SoundEvents.f_11867_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.SUMMON;
        }

        private void spawn(ServerLevel serverLevel, BlockPos blockpos, float angle) {
            CrystalEntity crystal = (CrystalEntity)((EntityType)EntityTypeRegistry.CRYSTAL.get()).m_20615_(WickedCrystal.this.m_9236_());
            if (crystal != null && serverLevel.m_46859_(blockpos)) {
                crystal.m_20035_(blockpos, 0.0f, 0.0f);
                crystal.m_6518_((ServerLevelAccessor)serverLevel, WickedCrystal.this.m_9236_().m_6436_(blockpos), MobSpawnType.MOB_SUMMONED, null, null);
                crystal.setOwner((LivingEntity)WickedCrystal.this);
                crystal.movement = new FlyingAroundMovement((Mob)crystal, (Entity)WickedCrystal.this);
                crystal.movement.setRadius(4.0f);
                crystal.movement.setAngle(angle);
                crystal.setBoundOrigin(blockpos);
                crystal.setLimitedLife(375);
                serverLevel.m_47205_((Entity)crystal);
            }
        }

        public void spawn(ServerLevel serv) {
            for (int i = 0; i < 4; ++i) {
                float initialAngle = (float)(1.5707963267948966 * (double)i);
                this.spawn(serv, WickedCrystal.this.m_20183_().m_7494_(), initialAngle);
            }
        }
    }

    public class RadialAttack
    extends MultiAttackMob.AttackGoal {
        public RadialAttack() {
            super((MultiAttackMob)WickedCrystal.this);
        }

        public void onPrepare() {
        }

        public boolean m_8036_() {
            return super.m_8036_() && WickedCrystal.this.m_20280_((Entity)WickedCrystal.this.m_5448_()) < 6.0;
        }

        protected void performSpellCasting(Level level, WickedCrystal crystal) {
            float yaw;
            double spellZ;
            double spellX;
            float angle;
            double d0 = Math.min((double)crystal.m_146908_(), crystal.m_20186_());
            double d1 = Math.max((double)crystal.m_146908_(), crystal.m_20186_()) + 1.0;
            float playerYaw = crystal.m_146908_() * ((float)Math.PI / 180);
            for (int i = 0; i < 6; ++i) {
                angle = playerYaw + (float)i * (float)Math.PI / 2.0f;
                spellX = crystal.m_20185_() + Math.cos(angle) * 1.5;
                spellZ = crystal.m_20189_() + Math.sin(angle) * 1.5;
                yaw = (float)(Math.atan2(crystal.m_20189_() - spellZ, crystal.m_20185_() - spellX) * 565.4866776461628);
                this.createSpellEntity(level, crystal.m_20185_() + Math.cos(angle) * 1.5, crystal.m_20189_() + Math.sin(angle) * 1.5, d0, d1, yaw, 0);
            }
            for (int k = 0; k < 12; ++k) {
                angle = playerYaw + (float)k * (float)Math.PI / 4.0f + 1.2566371f;
                spellX = crystal.m_20185_() + Math.cos(angle) * 3.0;
                spellZ = crystal.m_20189_() + Math.sin(angle) * 3.0;
                yaw = (float)(Math.atan2(crystal.m_20189_() - spellZ, crystal.m_20185_() - spellX) * 282.7433388230814);
                this.createSpellEntity(level, crystal.m_20185_() + Math.cos(angle) * 3.0, crystal.m_20189_() + Math.sin(angle) * 3.0, d0, d1, yaw, 6);
            }
        }

        private void createSpellEntity(Level level, double pX, double pZ, double pMinY, double pMaxY, float pYRot, int pWarmupDelay) {
            BlockPos blockpos = BlockPos.m_274561_((double)pX, (double)pMaxY, (double)pZ);
            boolean flag = false;
            double d0 = 0.0;
            do {
                BlockState blockstate1;
                VoxelShape voxelshape;
                BlockPos blockpos1;
                BlockState blockstate;
                if (!(blockstate = level.m_8055_(blockpos1 = blockpos.m_7495_())).m_60783_((BlockGetter)level, blockpos1, Direction.UP)) continue;
                if (!level.m_46859_(blockpos) && !(voxelshape = (blockstate1 = level.m_8055_(blockpos)).m_60812_((BlockGetter)level, blockpos)).m_83281_()) {
                    d0 = voxelshape.m_83297_(Direction.Axis.Y);
                }
                flag = true;
                break;
            } while ((blockpos = blockpos.m_7495_()).m_123342_() >= Mth.m_14107_((double)pMinY) - 1);
            if (flag && level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                PacketHandler.sendToTracking((Level)server, blockpos, new BeastAttackParticlePacket(pX, (double)blockpos.m_123342_() + d0, pZ, Pal.verySoftPink.toJava()));
                server.m_7967_((Entity)new CrystalSpikes((Level)server, pX, (double)blockpos.m_123342_() + d0, pZ, pYRot, pWarmupDelay, ((Integer)CommonConfig.RADIAL_WICKED_CRYSTAL_DAMAGE.get()).intValue(), null));
            }
        }

        protected void performAttack() {
            this.performSpellCasting(WickedCrystal.this.m_9236_(), WickedCrystal.this);
        }

        public int getPreparingTime() {
            return (Integer)CommonConfig.RADIAL_WICKED_CRYSTAL_CASTING_TIME.get();
        }

        public int getAttackInterval() {
            return (Integer)CommonConfig.RADIAL_WICKED_CRYSTAL_CASTING_INTERVAL.get();
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return SoundEvents.f_144243_;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.RADIAL;
        }
    }

    public class CrystalStorm
    extends MultiAttackMob.AttackGoal {
        public CrystalStorm() {
            super((MultiAttackMob)WickedCrystal.this);
        }

        public boolean m_8036_() {
            return super.m_8036_() && WickedCrystal.this.phase > 1;
        }

        private void summonRainCrystal(ServerLevel serverLevel, BlockPos center) {
            CrystalShard crystalShard = (CrystalShard)((EntityType)EntityTypeRegistry.CRYSTAL_SHARD.get()).m_20615_(WickedCrystal.this.m_9236_());
            if (crystalShard != null) {
                double spread = 6.0;
                double offsetX = WickedCrystal.this.f_19796_.m_188500_() * spread * 2.0 - spread;
                double offsetZ = WickedCrystal.this.f_19796_.m_188500_() * spread * 2.0 - spread;
                crystalShard.m_7678_((double)center.m_123341_() + 0.5 + offsetX, center.m_123342_() + 1, (double)center.m_123343_() + 0.5 + offsetZ, 0.0f, 0.0f);
                crystalShard.m_5602_((Entity)WickedCrystal.this);
                crystalShard.m_20334_(0.0, 1.0 + WickedCrystal.this.f_19796_.m_188500_() * 0.5, 0.0);
                serverLevel.m_7967_((Entity)crystalShard);
            }
        }

        private void summonStormCrystal(ServerLevel serverLevel, BlockPos spawnPos, float angle, double speed) {
            CrystalShard crystalShard = (CrystalShard)((EntityType)EntityTypeRegistry.CRYSTAL_SHARD.get()).m_20615_(WickedCrystal.this.m_9236_());
            if (crystalShard != null) {
                crystalShard.m_7678_((double)spawnPos.m_123341_() + 0.5, spawnPos.m_123342_() + 2, (double)spawnPos.m_123343_() + 0.5, 0.0f, 0.0f);
                crystalShard.m_5602_((Entity)WickedCrystal.this);
                double vx = Math.cos(angle) * speed;
                double vz = Math.sin(angle) * speed;
                crystalShard.m_20334_(vx, 0.3, vz);
                serverLevel.m_7967_((Entity)crystalShard);
            }
        }

        protected void performAttack() {
            float angle;
            int i;
            if (WickedCrystal.this.m_9236_().m_5776_()) {
                return;
            }
            ServerLevel serv = (ServerLevel)WickedCrystal.this.m_9236_();
            BlockPos center = WickedCrystal.this.m_20183_();
            for (i = 0; i < 12; ++i) {
                angle = (float)(0.5235987755982988 * (double)i);
                this.summonStormCrystal(serv, center, angle, 0.25);
            }
            if (Tmp.rnd.fiftyFifty()) {
                for (i = 0; i < 6; ++i) {
                    angle = (float)(1.0471975511965976 * (double)i);
                    this.summonStormCrystal(serv, center.m_6630_(2), angle, 0.35 + WickedCrystal.this.f_19796_.m_188500_() * 0.3);
                }
            } else {
                for (i = 0; i < 45; ++i) {
                    this.summonRainCrystal(serv, center);
                }
            }
        }

        public void onPrepare() {
        }

        public boolean m_183429_() {
            return true;
        }

        public int getPreparingTime() {
            return (Integer)CommonConfig.CRYSTAL_STORM_WICKED_CRYSTAL_CASTING_TIME.get();
        }

        public int getAttackInterval() {
            return (Integer)CommonConfig.CRYSTAL_STORM_WICKED_CRYSTAL_CASTING_INTERVAL.get();
        }

        @Nullable
        public SoundEvent getPrepareSound() {
            return (SoundEvent)SoundsRegistry.CRYSTAL_FALL.get();
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.THROW;
        }
    }
}

