/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living.boss;

import com.idark.valoria.client.particle.ParticleRegistry;
import java.util.EnumSet;
import java.util.Random;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import org.joml.Vector3d;
import pro.komaru.tridot.client.gfx.particle.ParticleBuilder;
import pro.komaru.tridot.client.gfx.particle.data.ColorParticleData;
import pro.komaru.tridot.client.gfx.particle.data.GenericParticleData;
import pro.komaru.tridot.client.gfx.particle.data.SpinParticleData;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;

public abstract class AbstractNecromancer
extends Monster {
    private static final EntityDataAccessor<Byte> DATA_SPELL_CASTING_ID = SynchedEntityData.m_135353_(AbstractNecromancer.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected int spellCastingTickCount;
    private NecromancerSpells currentSpell = NecromancerSpells.NONE;

    protected AbstractNecromancer(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SPELL_CASTING_ID, (Object)0);
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.spellCastingTickCount = pCompound.m_128451_("SpellTicks");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("SpellTicks", this.spellCastingTickCount);
    }

    public boolean hasTarget() {
        return this.m_5448_() != null;
    }

    public boolean isCastingSpell() {
        if (this.m_9236_().f_46443_) {
            return (Byte)this.f_19804_.m_135370_(DATA_SPELL_CASTING_ID) > 0;
        }
        return this.spellCastingTickCount > 0;
    }

    public void setIsCastingSpell(NecromancerSpells pCurrentSpell) {
        this.currentSpell = pCurrentSpell;
        this.f_19804_.m_135381_(DATA_SPELL_CASTING_ID, (Object)((byte)pCurrentSpell.id));
    }

    public NecromancerSpells getCurrentSpell() {
        return !this.m_9236_().f_46443_ ? this.currentSpell : NecromancerSpells.byId(((Byte)this.f_19804_.m_135370_(DATA_SPELL_CASTING_ID)).byteValue());
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.spellCastingTickCount > 0) {
            --this.spellCastingTickCount;
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_ && this.isCastingSpell()) {
            NecromancerSpells spell = this.getCurrentSpell();
            int r = spell.spellColor[0];
            int g = spell.spellColor[1];
            int b = spell.spellColor[2];
            float f = this.f_20883_ * ((float)Math.PI / 180) + Mth.m_14089_((float)((float)this.f_19797_ * 0.6662f)) * 0.25f;
            float f1 = Mth.m_14089_((float)f);
            float f2 = Mth.m_14031_((float)f);
            Col colorTo = new Col(r, g, b);
            int i = 0;
            while ((float)i < 1.0f) {
                ((ParticleBuilder)ParticleBuilder.create(ParticleRegistry.SPHERE).setLifetime(8).setTransparencyData(GenericParticleData.create((float)0.65f, (float)0.0f).build()).setColorData(ColorParticleData.create((Col)colorTo, (Col)Col.white).build()).addVelocity((this.f_19796_.m_188500_() - 0.5) / 6.0, (this.f_19796_.m_188500_() - 1.25) / 8.0, (this.f_19796_.m_188500_() - 0.5) / 6.0)).setSpinData(SpinParticleData.create((float)(0.5f * (float)((new Random().nextDouble() - 0.5) * 2.0))).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.0f).build()).spawn(this.m_9236_(), this.m_20185_() + 0.2 + (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() + 0.2 + (double)f2 * 0.6).spawn(this.m_9236_(), this.m_20185_() - 0.2 - (double)f1 * 0.6, this.m_20186_() + 1.8, this.m_20189_() - 0.2 - (double)f2 * 0.6);
                ++i;
            }
            if (spell.id == NecromancerSpells.SUMMON_MOBS.id || spell.id == NecromancerSpells.HEAL.id) {
                BlockPos blockpos = this.m_20183_().m_7918_(-2 + this.f_19796_.m_188503_(5), 0, -2 + this.f_19796_.m_188503_(5));
                Vector3d direction = new Vector3d(this.m_20185_() - (double)blockpos.m_123341_(), this.m_20186_() + (double)blockpos.m_123342_(), this.m_20189_() - (double)blockpos.m_123343_()).normalize();
                double speed = 0.3;
                double motionX = direction.x * speed;
                double motionY = direction.y * speed;
                double motionZ = direction.z * speed;
                int i2 = 0;
                while ((float)i2 < 0.2f) {
                    double startX = (double)blockpos.m_123341_() + 0.5;
                    double startY = (double)blockpos.m_123342_() - 0.2;
                    double startZ = (double)blockpos.m_123343_() + 0.5;
                    ((ParticleBuilder)((ParticleBuilder)ParticleBuilder.create(ParticleRegistry.SPHERE).setLifetime(8).addVelocity(motionX, motionY, motionZ)).setTransparencyData(GenericParticleData.create((float)0.65f, (float)0.0f).build()).setColorData(ColorParticleData.create((Col)colorTo, (Col)Col.white).build()).addVelocity((Tmp.rnd.nextDouble() - 0.5) / 6.0, ((double)Tmp.rnd.nextFloat() - 1.25) / 8.0, (Tmp.rnd.nextDouble() - 0.5) / 6.0)).setSpinData(SpinParticleData.create((float)(0.5f * (float)(((double)Tmp.rnd.nextFloat() - 0.5) * 2.0))).build()).setScaleData(GenericParticleData.create((float)0.2f, (float)0.0f).build()).spawn(this.m_9236_(), startX, startY, startZ);
                    ++i2;
                }
            }
        }
    }

    public int getSpellCastingTime() {
        return this.spellCastingTickCount;
    }

    public SoundEvent getCastingSoundEvent() {
        return SoundEvents.f_11862_;
    }

    public static enum NecromancerSpells {
        NONE(0, 0, 0, 0),
        SUMMON_MOBS(1, 30, 35, 75),
        FANGS(2, 160, 164, 164),
        WOLOLO(3, 46, 51, 60),
        HEAL(4, 164, 202, 65, true),
        KNOCKBACK(5, 185, 201, 203, true),
        EFFECT(6, 190, 105, 25);

        private static final IntFunction<NecromancerSpells> BY_ID;
        public final int id;
        public final boolean hasAura;
        public final int[] spellColor;

        private NecromancerSpells(int pId, int pRed, int pGreen, int pBlue, boolean pAura) {
            this.id = pId;
            this.hasAura = pAura;
            this.spellColor = new int[]{pRed, pGreen, pBlue};
        }

        private NecromancerSpells(int pId, int pRed, int pGreen, int pBlue) {
            this.id = pId;
            this.hasAura = false;
            this.spellColor = new int[]{pRed, pGreen, pBlue};
        }

        public static NecromancerSpells byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static boolean hasAura(int pId) {
            return NecromancerSpells.BY_ID.apply((int)pId).hasAura;
        }

        static {
            BY_ID = ByIdMap.m_262839_(p_263091_ -> p_263091_.id, (Object[])NecromancerSpells.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    public abstract class SpellcasterUseSpellGoal
    extends Goal {
        protected int attackWarmupDelay;
        protected int nextAttackTickCount;

        public boolean m_8036_() {
            LivingEntity livingentity = AbstractNecromancer.this.m_5448_();
            if (AbstractNecromancer.this.hasTarget() && livingentity.m_6084_()) {
                if (AbstractNecromancer.this.isCastingSpell()) {
                    return false;
                }
                return AbstractNecromancer.this.f_19797_ >= this.nextAttackTickCount;
            }
            return false;
        }

        public boolean m_8045_() {
            LivingEntity livingentity = AbstractNecromancer.this.m_5448_();
            return livingentity != null && livingentity.m_6084_() && this.attackWarmupDelay > 0;
        }

        public void m_8056_() {
            AbstractNecromancer.this.setIsCastingSpell(this.getSpell());
            this.attackWarmupDelay = this.m_183277_(this.getCastingTime());
            AbstractNecromancer.this.spellCastingTickCount = this.getCastingTime();
            this.nextAttackTickCount = AbstractNecromancer.this.f_19797_ + this.getCastingInterval();
            SoundEvent soundevent = this.getSpellPrepareSound();
            if (soundevent != null) {
                AbstractNecromancer.this.m_5496_(soundevent, 1.0f, 1.0f);
            }
        }

        public void m_8037_() {
            --this.attackWarmupDelay;
            if (this.attackWarmupDelay == 0) {
                this.performSpellCasting();
                AbstractNecromancer.this.m_5496_(AbstractNecromancer.this.getCastingSoundEvent(), 1.0f, 1.0f);
            }
        }

        protected abstract void performSpellCasting();

        public abstract int getCastingTime();

        public abstract int getCastingInterval();

        @Nullable
        public abstract SoundEvent getSpellPrepareSound();

        public abstract NecromancerSpells getSpell();
    }

    public class SpellcasterCastingSpellGoal
    extends Goal {
        public SpellcasterCastingSpellGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return AbstractNecromancer.this.getSpellCastingTime() > 0;
        }

        public void m_8056_() {
            super.m_8056_();
            AbstractNecromancer.this.f_21344_.m_26573_();
        }

        public void m_8041_() {
            super.m_8041_();
            AbstractNecromancer.this.setIsCastingSpell(NecromancerSpells.NONE);
        }

        public void m_8037_() {
            if (AbstractNecromancer.this.m_5448_() != null) {
                AbstractNecromancer.this.m_21563_().m_24960_((Entity)AbstractNecromancer.this.m_5448_(), (float)AbstractNecromancer.this.m_8085_(), (float)AbstractNecromancer.this.m_8132_());
            }
        }
    }
}

