/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.idark.valoria.registries.EntityStatsRegistry;
import com.idark.valoria.registries.EntityTypeRegistry;
import com.idark.valoria.registries.entity.ai.movements.SkeletonMovement;
import com.idark.valoria.registries.entity.projectile.SpellProjectile;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FleeSunGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RestrictSunGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.joml.Vector3d;
import pro.komaru.tridot.api.Utils;
import pro.komaru.tridot.api.entity.AttackRegistry;
import pro.komaru.tridot.common.registry.entity.MultiAttackMob;
import pro.komaru.tridot.util.Col;
import pro.komaru.tridot.util.Tmp;

public class SorcererEntity
extends MultiAttackMob
implements Enemy,
RangedAttackMob {
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState attackHatAnimationState = new AnimationState();
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState healAnimationState = new AnimationState();
    private int idleAnimationTimeout = 0;
    public SkeletonMovement movement = new SkeletonMovement((Mob)this);

    public SorcererEntity(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_21364_ = 5;
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public SorcererEntity(Level pLevel) {
        this((EntityType<? extends PathfinderMob>)((EntityType)EntityTypeRegistry.SORCERER.get()), pLevel);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        this.movement.setupMovement();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(this.getStepSound(), 0.15f, 1.0f);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.f_12383_;
    }

    public boolean m_7307_(Entity pEntity) {
        if (super.m_7307_(pEntity)) {
            return true;
        }
        if (pEntity instanceof LivingEntity && ((LivingEntity)pEntity).m_6336_() == MobType.f_21641_) {
            return this.m_5647_() == null && pEntity.m_5647_() == null;
        }
        return false;
    }

    private void setupAnimationStates() {
        if (this.idleAnimationTimeout <= 0) {
            this.idleAnimationTimeout = 60;
            this.idleAnimationState.m_216977_(this.f_19797_);
        } else {
            --this.idleAnimationTimeout;
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RestrictSunGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new FleeSunGoal((PathfinderMob)this, 1.0));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(0, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(0, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(0, (Goal)new CastSpellGoal(this, 16.0f));
        this.f_21345_.m_25352_(0, (Goal)new HealTargetSpell());
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.2));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, Wolf.class, 8.0f, 1.5, 1.5));
        this.f_21345_.m_25352_(1, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_7822_(byte pId) {
        if (pId == 62) {
            if (Tmp.rnd.chance(0.75f)) {
                this.attackAnimationState.m_216977_(this.f_19797_);
            } else {
                this.attackHatAnimationState.m_216977_(this.f_19797_);
            }
        } else if (pId == 64) {
            this.healAnimationState.m_216977_(this.f_19797_);
        } else {
            super.m_7822_(pId);
        }
    }

    public void m_6504_(LivingEntity pTarget, float pVelocity) {
        SpellProjectile spell = new SpellProjectile(this.m_9236_(), (LivingEntity)this, 6);
        double d0 = pTarget.m_20185_() - this.m_20185_();
        double d1 = pTarget.m_20227_(0.3333333333333333) - spell.m_20186_();
        double d2 = pTarget.m_20189_() - this.m_20189_();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        spell.setColor(Col.fromHex((String)"ffab51"));
        spell.m_6686_(d0, d1 + d3 * (double)0.2f, d2, 1.6f, 14 - this.m_9236_().m_46791_().m_19028_() * 4);
        this.m_9236_().m_7967_((Entity)spell);
    }

    public static boolean checkMonsterSpawnRules(EntityType<? extends SorcererEntity> pType, ServerLevelAccessor pLevel, MobSpawnType pSpawnType, BlockPos pPos, RandomSource pRandom) {
        return pLevel.m_46791_() != Difficulty.PEACEFUL && SorcererEntity.isDarkEnoughToSpawn(pLevel, pPos, pRandom) && SorcererEntity.m_217057_(pType, (LevelAccessor)pLevel, (MobSpawnType)pSpawnType, (BlockPos)pPos, (RandomSource)pRandom);
    }

    public static boolean isDarkEnoughToSpawn(ServerLevelAccessor pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.m_45517_(LightLayer.SKY, pPos) > pRandom.m_188503_(32)) {
            return false;
        }
        DimensionType dimensiontype = pLevel.m_6042_();
        int i = dimensiontype.m_223570_();
        if (i < 15 && pLevel.m_45517_(LightLayer.BLOCK, pPos) > i) {
            return false;
        }
        int j = pLevel.m_6018_().m_46470_() ? pLevel.m_46849_(pPos, 10) : pLevel.m_46803_(pPos);
        return j <= dimensiontype.m_223569_().m_214085_(pRandom);
    }

    public class CastSpellGoal
    extends MultiAttackMob.AttackGoal {
        private final Mob mob;
        private final RangedAttackMob rangedAttackMob;
        private final float attackRadius;

        public CastSpellGoal(RangedAttackMob pRangedAttackMob, float pAttackRadius) {
            super((MultiAttackMob)SorcererEntity.this);
            this.rangedAttackMob = pRangedAttackMob;
            this.mob = (Mob)pRangedAttackMob;
            this.attackRadius = pAttackRadius;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean m_6767_() {
            return false;
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            LivingEntity livingentity = this.mob.m_5448_();
            return super.m_8036_() && livingentity != null;
        }

        protected void performAttack() {
            double d0 = this.mob.m_20275_(this.mob.m_5448_().m_20185_(), this.mob.m_5448_().m_20186_(), this.mob.m_5448_().m_20189_());
            float f = (float)Math.sqrt(d0) / this.attackRadius;
            float f1 = Mth.m_14036_((float)f, (float)0.1f, (float)1.0f);
            this.rangedAttackMob.m_6504_(this.mob.m_5448_(), f1);
        }

        public void onPrepare() {
            SorcererEntity.this.m_9236_().m_7605_((Entity)SorcererEntity.this, (byte)62);
        }

        public int getPreparingTime() {
            return 20;
        }

        public int getAttackInterval() {
            return 70;
        }

        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.MAGIC;
        }
    }

    public class HealTargetSpell
    extends MultiAttackMob.AttackGoal {
        private final TargetingConditions targeting;

        public HealTargetSpell() {
            super((MultiAttackMob)SorcererEntity.this);
            this.targeting = TargetingConditions.m_148352_().m_26883_(6.0);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.LOOK));
        }

        public boolean m_183429_() {
            return true;
        }

        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            List targets = SorcererEntity.this.m_9236_().m_45971_(Monster.class, this.targeting, (LivingEntity)SorcererEntity.this, SorcererEntity.this.m_20191_().m_82400_(6.0));
            return !targets.isEmpty();
        }

        protected void performAttack() {
            ServerLevel serverLevel = (ServerLevel)SorcererEntity.this.m_9236_();
            List targets = serverLevel.m_45971_(Monster.class, this.targeting, (LivingEntity)SorcererEntity.this, SorcererEntity.this.m_20191_().m_82400_(6.0));
            ArrayList toHeal = new ArrayList();
            for (Monster target : targets) {
                if (!(target.m_21223_() < target.m_21233_())) continue;
                Vector3d pos = new Vector3d(SorcererEntity.this.m_20185_(), SorcererEntity.this.m_20186_(), SorcererEntity.this.m_20189_());
                Utils.Particles.inRadius((Level)serverLevel, null, (ParticleOptions)ParticleTypes.f_123748_, (Vector3d)pos, (float)0.0f, (float)SorcererEntity.this.m_20155_().f_82471_, (float)6.0f);
                Utils.Hit.healNearbyMobs((MobCategory)MobCategory.MONSTER, (Float)Float.valueOf(4.0f), (Level)serverLevel, (LivingEntity)SorcererEntity.this, toHeal, (Vector3d)pos, (float)0.0f, (float)SorcererEntity.this.m_20155_().f_82471_, (float)6.0f);
                serverLevel.m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), SoundEvents.f_11862_, target.m_5720_(), 0.42f, 1.23f);
                break;
            }
        }

        public boolean m_6767_() {
            return false;
        }

        public void onPrepare() {
            SorcererEntity.this.m_9236_().m_7605_((Entity)SorcererEntity.this, (byte)64);
        }

        public int getPreparingTime() {
            return 80;
        }

        public int getAttackInterval() {
            return 160;
        }

        public SoundEvent getPrepareSound() {
            return null;
        }

        public AttackRegistry getAttack() {
            return EntityStatsRegistry.HEAL;
        }
    }
}

