/*
 * Decompiled with CFR 0.152.
 */
package com.idark.valoria.registries.entity.living;

import com.idark.valoria.registries.EntityTypeRegistry;
import java.util.function.IntFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.goal.ClimbOnTopOfPowderSnowGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MaggotEntity
extends Monster {
    private static final EntityDataAccessor<Integer> TYPE = SynchedEntityData.m_135353_(MaggotEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public Variant variant;

    public MaggotEntity(Level pLevel) {
        super((EntityType)EntityTypeRegistry.MAGGOT.get(), pLevel);
        if (!pLevel.f_46443_) {
            this.setType(Variant.byId(this.f_19796_.m_188503_(Variant.values().length)));
        }
    }

    public MaggotEntity(EntityType<? extends MaggotEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        if (!pLevel.f_46443_) {
            this.setType(Variant.byId(this.f_19796_.m_188503_(Variant.values().length)));
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ClimbOnTopOfPowderSnowGoal((Mob)this, this.m_9236_()));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, false));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public boolean m_7327_(Entity pEntity) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity target = (LivingEntity)pEntity;
            switch (this.getVariant()) {
                case MAGGOT_ROT: {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 30));
                    break;
                }
                case MAGGOT_ROTTEN: {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 50));
                }
            }
        }
        return super.m_7327_(pEntity);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)0);
    }

    public void setType(Variant variant) {
        this.variant = variant;
        this.f_19804_.m_135381_(TYPE, (Object)variant.getId());
    }

    public Variant getVariant() {
        return Variant.byId((Integer)this.f_19804_.m_135370_(TYPE));
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.variant.getId());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.variant = Variant.byId(pCompound.m_128451_("Variant"));
    }

    public double m_6049_() {
        return 0.1;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return 0.13f;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.EVENTS;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12419_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12421_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12420_;
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12422_, 0.15f, 1.0f);
    }

    public void m_8119_() {
        this.f_20883_ = this.m_146908_();
        super.m_8119_();
    }

    public void m_5618_(float pOffset) {
        this.m_146922_(pOffset);
        super.m_5618_(pOffset);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public static enum Variant {
        MAGGOT(0, "Maggot"),
        MAGGOT_ROT(1, "MaggotRot"),
        MAGGOT_ROTTEN(2, "MaggotRotten");

        private static final IntFunction<Variant> BY_ID;
        public String type;
        public final int id;

        private Variant(int id, String type) {
            this.id = id;
            this.type = type;
        }

        public String getString() {
            return this.type;
        }

        public int getId() {
            return this.id;
        }

        public static Variant byId(int pId) {
            return BY_ID.apply(pId);
        }

        static {
            BY_ID = ByIdMap.m_262839_(p_263091_ -> p_263091_.id, (Object[])Variant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

